/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.InclusiveStopFilter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.QualifierFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.SkipFilter;
import org.apache.hadoop.hbase.filter.SubstringComparator;
import org.apache.hadoop.hbase.filter.ValueFilter;
import org.apache.hadoop.hbase.rest.HBaseRESTTestingUtility;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.Response;
import org.apache.hadoop.hbase.rest.model.CellModel;
import org.apache.hadoop.hbase.rest.model.CellSetModel;
import org.apache.hadoop.hbase.rest.model.RowModel;
import org.apache.hadoop.hbase.rest.model.ScannerModel;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestScannersWithFilters {
    private static final Log LOG = LogFactory.getLog(TestScannersWithFilters.class);
    private static final String TABLE = "TestScannersWithFilters";
    private static final byte[][] ROWS_ONE = new byte[][]{Bytes.toBytes((String)"testRowOne-0"), Bytes.toBytes((String)"testRowOne-1"), Bytes.toBytes((String)"testRowOne-2"), Bytes.toBytes((String)"testRowOne-3")};
    private static final byte[][] ROWS_TWO = new byte[][]{Bytes.toBytes((String)"testRowTwo-0"), Bytes.toBytes((String)"testRowTwo-1"), Bytes.toBytes((String)"testRowTwo-2"), Bytes.toBytes((String)"testRowTwo-3")};
    private static final byte[][] FAMILIES = new byte[][]{Bytes.toBytes((String)"testFamilyOne"), Bytes.toBytes((String)"testFamilyTwo")};
    private static final byte[][] QUALIFIERS_ONE = new byte[][]{Bytes.toBytes((String)"testQualifierOne-0"), Bytes.toBytes((String)"testQualifierOne-1"), Bytes.toBytes((String)"testQualifierOne-2"), Bytes.toBytes((String)"testQualifierOne-3")};
    private static final byte[][] QUALIFIERS_TWO = new byte[][]{Bytes.toBytes((String)"testQualifierTwo-0"), Bytes.toBytes((String)"testQualifierTwo-1"), Bytes.toBytes((String)"testQualifierTwo-2"), Bytes.toBytes((String)"testQualifierTwo-3")};
    private static final byte[][] VALUES = new byte[][]{Bytes.toBytes((String)"testValueOne"), Bytes.toBytes((String)"testValueTwo")};
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final HBaseRESTTestingUtility REST_TEST_UTIL = new HBaseRESTTestingUtility();
    private static Client client;
    private static JAXBContext context;
    private static Marshaller marshaller;
    private static Unmarshaller unmarshaller;
    private static long numRows;
    private static long colsPerRow;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
        REST_TEST_UTIL.startServletContainer(TEST_UTIL.getConfiguration());
        context = JAXBContext.newInstance((Class[])new Class[]{CellModel.class, CellSetModel.class, RowModel.class, ScannerModel.class});
        marshaller = context.createMarshaller();
        unmarshaller = context.createUnmarshaller();
        client = new Client(new Cluster().add("localhost", REST_TEST_UTIL.getServletPort()));
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        if (!admin.tableExists(TABLE)) {
            Delete d;
            Put p;
            HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)TABLE));
            htd.addFamily(new HColumnDescriptor(FAMILIES[0]));
            htd.addFamily(new HColumnDescriptor(FAMILIES[1]));
            admin.createTable(htd);
            HTable table = new HTable(TEST_UTIL.getConfiguration(), TABLE);
            for (byte[] ROW : ROWS_ONE) {
                p = new Put(ROW);
                p.setDurability(Durability.SKIP_WAL);
                for (byte[] QUALIFIER : QUALIFIERS_ONE) {
                    p.add(FAMILIES[0], QUALIFIER, VALUES[0]);
                }
                table.put(p);
            }
            for (byte[] ROW : ROWS_TWO) {
                p = new Put(ROW);
                p.setDurability(Durability.SKIP_WAL);
                for (byte[] QUALIFIER : QUALIFIERS_TWO) {
                    p.add(FAMILIES[1], QUALIFIER, VALUES[1]);
                }
                table.put(p);
            }
            for (byte[] ROW : ROWS_ONE) {
                p = new Put(ROW);
                p.setDurability(Durability.SKIP_WAL);
                for (byte[] QUALIFIER : QUALIFIERS_ONE) {
                    p.add(FAMILIES[1], QUALIFIER, VALUES[0]);
                }
                table.put(p);
            }
            for (byte[] ROW : ROWS_TWO) {
                p = new Put(ROW);
                p.setDurability(Durability.SKIP_WAL);
                for (byte[] QUALIFIER : QUALIFIERS_TWO) {
                    p.add(FAMILIES[0], QUALIFIER, VALUES[1]);
                }
                table.put(p);
            }
            for (byte[] ROW : ROWS_ONE) {
                d = new Delete(ROW);
                d.deleteColumns(FAMILIES[0], QUALIFIERS_ONE[1]);
                d.deleteColumns(FAMILIES[1], QUALIFIERS_ONE[1]);
                table.delete(d);
            }
            for (byte[] ROW : ROWS_TWO) {
                d = new Delete(ROW);
                d.deleteColumns(FAMILIES[0], QUALIFIERS_TWO[1]);
                d.deleteColumns(FAMILIES[1], QUALIFIERS_TWO[1]);
                table.delete(d);
            }
            colsPerRow -= 2L;
            for (byte[] QUALIFIER : QUALIFIERS_ONE) {
                d = new Delete(ROWS_ONE[1]);
                d.deleteColumns(FAMILIES[0], QUALIFIER);
                d.deleteColumns(FAMILIES[1], QUALIFIER);
                table.delete(d);
            }
            for (byte[] QUALIFIER : QUALIFIERS_TWO) {
                d = new Delete(ROWS_TWO[1]);
                d.deleteColumns(FAMILIES[0], QUALIFIER);
                d.deleteColumns(FAMILIES[1], QUALIFIER);
                table.delete(d);
            }
            numRows -= 2L;
            table.close();
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        REST_TEST_UTIL.shutdownServletContainer();
        TEST_UTIL.shutdownMiniCluster();
    }

    private static void verifyScan(Scan s, long expectedRows, long expectedKeys) throws Exception {
        ScannerModel model = ScannerModel.fromScan((Scan)s);
        model.setBatch(Integer.MAX_VALUE);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)model, (Writer)writer);
        LOG.debug((Object)writer.toString());
        byte[] body = Bytes.toBytes((String)writer.toString());
        Response response = client.put("/TestScannersWithFilters/scanner", "text/xml", body);
        Assert.assertEquals((long)response.getCode(), (long)201L);
        String scannerURI = response.getLocation();
        Assert.assertNotNull((Object)scannerURI);
        response = client.get(scannerURI, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cells = (CellSetModel)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        int rows = cells.getRows().size();
        Assert.assertTrue((String)("Scanned too many rows! Only expected " + expectedRows + " total but scanned " + rows), (expectedRows == (long)rows ? 1 : 0) != 0);
        for (RowModel row : cells.getRows()) {
            int count = row.getCells().size();
            Assert.assertEquals((String)("Expected " + expectedKeys + " keys per row but " + "returned " + count), (long)expectedKeys, (long)count);
        }
        response = client.delete(scannerURI);
        Assert.assertEquals((long)response.getCode(), (long)200L);
    }

    private static void verifyScanFull(Scan s, KeyValue[] kvs) throws Exception {
        RowModel rowModel;
        List cells;
        ScannerModel model = ScannerModel.fromScan((Scan)s);
        model.setBatch(Integer.MAX_VALUE);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)model, (Writer)writer);
        LOG.debug((Object)writer.toString());
        byte[] body = Bytes.toBytes((String)writer.toString());
        Response response = client.put("/TestScannersWithFilters/scanner", "text/xml", body);
        Assert.assertEquals((long)response.getCode(), (long)201L);
        String scannerURI = response.getLocation();
        Assert.assertNotNull((Object)scannerURI);
        response = client.get(scannerURI, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        response = client.delete(scannerURI);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        int row = 0;
        int idx = 0;
        Iterator i = cellSet.getRows().iterator();
        boolean done = true;
        while (done && (done = i.hasNext()) && !(cells = (rowModel = (RowModel)i.next()).getCells()).isEmpty()) {
            Assert.assertTrue((String)("Scanned too many keys! Only expected " + kvs.length + " total but already scanned " + (cells.size() + idx)), (kvs.length >= idx + cells.size() ? 1 : 0) != 0);
            for (CellModel cell : cells) {
                Assert.assertTrue((String)"Row mismatch", (boolean)Bytes.equals((byte[])rowModel.getKey(), (byte[])kvs[idx].getRow()));
                byte[][] split = KeyValue.parseColumn((byte[])cell.getColumn());
                Assert.assertTrue((String)"Family mismatch", (boolean)Bytes.equals((byte[])split[0], (byte[])kvs[idx].getFamily()));
                Assert.assertTrue((String)"Qualifier mismatch", (boolean)Bytes.equals((byte[])split[1], (byte[])kvs[idx].getQualifier()));
                Assert.assertTrue((String)"Value mismatch", (boolean)Bytes.equals((byte[])cell.getValue(), (byte[])kvs[idx].getValue()));
                ++idx;
            }
            ++row;
        }
        Assert.assertEquals((String)("Expected " + kvs.length + " total keys but scanned " + idx), (long)kvs.length, (long)idx);
    }

    private static void verifyScanNoEarlyOut(Scan s, long expectedRows, long expectedKeys) throws Exception {
        RowModel rowModel;
        List cells;
        ScannerModel model = ScannerModel.fromScan((Scan)s);
        model.setBatch(Integer.MAX_VALUE);
        StringWriter writer = new StringWriter();
        marshaller.marshal((Object)model, (Writer)writer);
        LOG.debug((Object)writer.toString());
        byte[] body = Bytes.toBytes((String)writer.toString());
        Response response = client.put("/TestScannersWithFilters/scanner", "text/xml", body);
        Assert.assertEquals((long)response.getCode(), (long)201L);
        String scannerURI = response.getLocation();
        Assert.assertNotNull((Object)scannerURI);
        response = client.get(scannerURI, "text/xml");
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Assert.assertEquals((Object)"text/xml", (Object)response.getHeader("content-type"));
        CellSetModel cellSet = (CellSetModel)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response.getBody()));
        response = client.delete(scannerURI);
        Assert.assertEquals((long)response.getCode(), (long)200L);
        Iterator i = cellSet.getRows().iterator();
        int j = 0;
        boolean done = true;
        while (done && (done = i.hasNext()) && !(cells = (rowModel = (RowModel)i.next()).getCells()).isEmpty()) {
            Assert.assertTrue((String)("Scanned too many rows! Only expected " + expectedRows + " total but already scanned " + (j + 1)), (expectedRows > (long)j ? 1 : 0) != 0);
            Assert.assertEquals((String)("Expected " + expectedKeys + " keys per row but " + "returned " + cells.size()), (long)expectedKeys, (long)cells.size());
            ++j;
        }
        Assert.assertEquals((String)("Expected " + expectedRows + " rows but scanned " + j + " rows"), (long)expectedRows, (long)j);
    }

    @Test
    public void testNoFilter() throws Exception {
        long expectedRows = numRows;
        long expectedKeys = colsPerRow;
        Scan s = new Scan();
        TestScannersWithFilters.verifyScan(s, expectedRows, expectedKeys);
        s = new Scan();
        s.addFamily(FAMILIES[0]);
        TestScannersWithFilters.verifyScan(s, expectedRows, expectedKeys / 2L);
    }

    @Test
    public void testPrefixFilter() throws Exception {
        long expectedRows = numRows / 2L;
        long expectedKeys = colsPerRow;
        Scan s = new Scan();
        s.setFilter((Filter)new PrefixFilter(Bytes.toBytes((String)"testRowOne")));
        TestScannersWithFilters.verifyScan(s, expectedRows, expectedKeys);
    }

    @Test
    public void testPageFilter() throws Exception {
        KeyValue[] expectedKVs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        long expectedRows = 6L;
        long expectedKeys = colsPerRow;
        Scan s = new Scan();
        s.setFilter((Filter)new PageFilter(expectedRows));
        TestScannersWithFilters.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter((Filter)new PageFilter(expectedRows));
        TestScannersWithFilters.verifyScanFull(s, expectedKVs);
        expectedRows = 4L;
        expectedKeys = colsPerRow;
        s = new Scan();
        s.setFilter((Filter)new PageFilter(expectedRows));
        TestScannersWithFilters.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter((Filter)new PageFilter(expectedRows));
        TestScannersWithFilters.verifyScanFull(s, Arrays.copyOf(expectedKVs, 24));
        expectedRows = 2L;
        expectedKeys = colsPerRow;
        s = new Scan();
        s.setFilter((Filter)new PageFilter(expectedRows));
        TestScannersWithFilters.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter((Filter)new PageFilter(expectedRows));
        TestScannersWithFilters.verifyScanFull(s, Arrays.copyOf(expectedKVs, 12));
        expectedRows = 1L;
        expectedKeys = colsPerRow;
        s = new Scan();
        s.setFilter((Filter)new PageFilter(expectedRows));
        TestScannersWithFilters.verifyScan(s, expectedRows, expectedKeys);
        s.setFilter((Filter)new PageFilter(expectedRows));
        TestScannersWithFilters.verifyScanFull(s, Arrays.copyOf(expectedKVs, 6));
    }

    @Test
    public void testInclusiveStopFilter() throws Exception {
        long expectedRows = numRows / 2L - 1L;
        long expectedKeys = colsPerRow;
        Scan s = new Scan(Bytes.toBytes((String)"testRowOne-0"), Bytes.toBytes((String)"testRowOne-3"));
        TestScannersWithFilters.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        s = new Scan(Bytes.toBytes((String)"testRowOne-0"));
        s.setFilter((Filter)new InclusiveStopFilter(Bytes.toBytes((String)"testRowOne-3")));
        TestScannersWithFilters.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L - 1L;
        expectedKeys = colsPerRow;
        s = new Scan(Bytes.toBytes((String)"testRowTwo-0"), Bytes.toBytes((String)"testRowTwo-3"));
        TestScannersWithFilters.verifyScan(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        s = new Scan(Bytes.toBytes((String)"testRowTwo-0"));
        s.setFilter((Filter)new InclusiveStopFilter(Bytes.toBytes((String)"testRowTwo-3")));
        TestScannersWithFilters.verifyScan(s, expectedRows, expectedKeys);
    }

    @Test
    public void testQualifierFilter() throws Exception {
        long expectedRows = numRows / 2L;
        long expectedKeys = 2L;
        QualifierFilter f = new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        Scan s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        expectedKeys = 2L;
        f = new QualifierFilter(CompareFilter.CompareOp.LESS, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        expectedKeys = 4L;
        f = new QualifierFilter(CompareFilter.CompareOp.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        expectedKeys = 4L;
        f = new QualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"testRowTwo"));
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        expectedKeys = 4L;
        f = new QualifierFilter(CompareFilter.CompareOp.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"testRowTwo"));
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        expectedKeys = 2L;
        f = new QualifierFilter(CompareFilter.CompareOp.GREATER, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2")));
        s = new Scan(HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"testRowTwo"));
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        f = new QualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(QUALIFIERS_ONE[2]));
        s = new Scan();
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        TestScannersWithFilters.verifyScanFull(s, kvs);
        f = new QualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new RegexStringComparator("test.+-2"));
        s = new Scan();
        s.setFilter((Filter)f);
        kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        TestScannersWithFilters.verifyScanFull(s, kvs);
    }

    @Test
    public void testRowFilter() throws Exception {
        long expectedRows = 1L;
        long expectedKeys = colsPerRow;
        RowFilter f = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        Scan s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = 2L;
        expectedKeys = colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator("testRow.+-2"));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = 1L;
        expectedKeys = colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.LESS, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = 2L;
        expectedKeys = colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows - 1L;
        expectedKeys = colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows - 1L;
        expectedKeys = colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows - 2L;
        expectedKeys = colsPerRow;
        f = new RowFilter(CompareFilter.CompareOp.GREATER, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        f = new RowFilter(CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testRowOne-2")));
        s = new Scan();
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[0], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        TestScannersWithFilters.verifyScanFull(s, kvs);
        f = new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(".+-2"));
        s = new Scan();
        s.setFilter((Filter)f);
        kvs = new KeyValue[]{new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[2], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[1], QUALIFIERS_ONE[3], VALUES[0]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        TestScannersWithFilters.verifyScanFull(s, kvs);
    }

    @Test
    public void testValueFilter() throws Exception {
        long expectedRows = numRows / 2L;
        long expectedKeys = colsPerRow;
        ValueFilter f = new ValueFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        Scan s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        expectedKeys = colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueTwo")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows;
        expectedKeys = colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator("testValue((One)|(Two))"));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        expectedKeys = colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.LESS, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueTwo")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows;
        expectedKeys = colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueTwo")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        expectedKeys = colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.LESS_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        expectedKeys = colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows;
        expectedKeys = colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.GREATER_OR_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        expectedRows = numRows / 2L;
        expectedKeys = colsPerRow;
        f = new ValueFilter(CompareFilter.CompareOp.GREATER, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, expectedRows, expectedKeys);
        f = new ValueFilter(CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testValueOne")));
        s = new Scan();
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        TestScannersWithFilters.verifyScanFull(s, kvs);
    }

    @Test
    public void testSkipFilter() throws Exception {
        SkipFilter f = new SkipFilter((Filter)new QualifierFilter(CompareFilter.CompareOp.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(Bytes.toBytes((String)"testQualifierOne-2"))));
        Scan s = new Scan();
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[0], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[3], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[2], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[1], QUALIFIERS_TWO[3], VALUES[1])};
        TestScannersWithFilters.verifyScanFull(s, kvs);
    }

    @Test
    public void testFilterList() throws Exception {
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(".+-2")));
        filters.add(new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(".+-2")));
        filters.add(new ValueFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new SubstringComparator("One")));
        FilterList f = new FilterList(FilterList.Operator.MUST_PASS_ALL, filters);
        Scan s = new Scan();
        s.addFamily(FAMILIES[0]);
        s.setFilter((Filter)f);
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[2], VALUES[0])};
        TestScannersWithFilters.verifyScanFull(s, kvs);
        filters.clear();
        filters.add(new RowFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(".+Two.+")));
        filters.add(new QualifierFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new RegexStringComparator(".+-2")));
        filters.add(new ValueFilter(CompareFilter.CompareOp.EQUAL, (ByteArrayComparable)new SubstringComparator("One")));
        f = new FilterList(FilterList.Operator.MUST_PASS_ONE, filters);
        s = new Scan();
        s.setFilter((Filter)f);
        TestScannersWithFilters.verifyScanNoEarlyOut(s, numRows, colsPerRow);
    }

    @Test
    public void testFirstKeyOnlyFilter() throws Exception {
        Scan s = new Scan();
        s.setFilter((Filter)new FirstKeyOnlyFilter());
        KeyValue[] kvs = new KeyValue[]{new KeyValue(ROWS_ONE[0], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[2], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_ONE[3], FAMILIES[0], QUALIFIERS_ONE[0], VALUES[0]), new KeyValue(ROWS_TWO[0], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[2], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1]), new KeyValue(ROWS_TWO[3], FAMILIES[0], QUALIFIERS_TWO[0], VALUES[1])};
        TestScannersWithFilters.verifyScanFull(s, kvs);
    }

    static {
        numRows = ROWS_ONE.length + ROWS_TWO.length;
        colsPerRow = FAMILIES.length * QUALIFIERS_ONE.length;
    }
}

