/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import org.apache.hadoop.hbase.rest.model.ColumnSchemaModel;
import org.apache.hadoop.hbase.rest.model.TestModelBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestColumnSchemaModel
extends TestModelBase<ColumnSchemaModel> {
    protected static final String COLUMN_NAME = "testcolumn";
    protected static final boolean BLOCKCACHE = true;
    protected static final int BLOCKSIZE = 16384;
    protected static final String BLOOMFILTER = "NONE";
    protected static final String COMPRESSION = "GZ";
    protected static final boolean IN_MEMORY = false;
    protected static final int TTL = 86400;
    protected static final int VERSIONS = 1;

    public TestColumnSchemaModel() throws Exception {
        super(ColumnSchemaModel.class);
        this.AS_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ColumnSchema name=\"testcolumn\" BLOCKSIZE=\"16384\" BLOOMFILTER=\"NONE\" BLOCKCACHE=\"true\" COMPRESSION=\"GZ\" VERSIONS=\"1\" TTL=\"86400\" IN_MEMORY=\"false\"/>";
        this.AS_JSON = "{\"name\":\"testcolumn\",\"BLOCKSIZE\":\"16384\",\"BLOOMFILTER\":\"NONE\",\"BLOCKCACHE\":\"true\",\"COMPRESSION\":\"GZ\",\"VERSIONS\":\"1\",\"TTL\":\"86400\",\"IN_MEMORY\":\"false\"}";
    }

    @Override
    protected ColumnSchemaModel buildTestModel() {
        ColumnSchemaModel model = new ColumnSchemaModel();
        model.setName(COLUMN_NAME);
        model.__setBlocksize(16384);
        model.__setBloomfilter(BLOOMFILTER);
        model.__setBlockcache(true);
        model.__setCompression(COMPRESSION);
        model.__setVersions(1);
        model.__setTTL(86400);
        model.__setInMemory(false);
        return model;
    }

    @Override
    protected void checkModel(ColumnSchemaModel model) {
        TestColumnSchemaModel.assertEquals((String)model.getName(), (String)COLUMN_NAME);
        TestColumnSchemaModel.assertEquals((boolean)model.__getBlockcache(), (boolean)true);
        TestColumnSchemaModel.assertEquals((int)model.__getBlocksize(), (int)16384);
        TestColumnSchemaModel.assertEquals((String)model.__getBloomfilter(), (String)BLOOMFILTER);
        TestColumnSchemaModel.assertTrue((boolean)model.__getCompression().equalsIgnoreCase(COMPRESSION));
        TestColumnSchemaModel.assertEquals((boolean)model.__getInMemory(), (boolean)false);
        TestColumnSchemaModel.assertEquals((int)model.__getTTL(), (int)86400);
        TestColumnSchemaModel.assertEquals((int)model.__getVersions(), (int)1);
    }

    @Override
    public void testFromPB() throws Exception {
    }
}

