/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.rest.ExistsResource;
import org.apache.hadoop.hbase.rest.MultiRowResource;
import org.apache.hadoop.hbase.rest.RESTServlet;
import org.apache.hadoop.hbase.rest.RegionsResource;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.RowResource;
import org.apache.hadoop.hbase.rest.ScannerResource;
import org.apache.hadoop.hbase.rest.SchemaResource;
import org.apache.hadoop.hbase.rest.TableScanResource;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class TableResource
extends ResourceBase {
    String table;
    private static final Log LOG = LogFactory.getLog(TableResource.class);

    public TableResource(String table) throws IOException {
        this.table = table;
    }

    String getName() {
        return this.table;
    }

    boolean exists() throws IOException {
        return this.servlet.getAdmin().tableExists(this.table);
    }

    @Path(value="exists")
    public ExistsResource getExistsResource() throws IOException {
        return new ExistsResource(this);
    }

    @Path(value="regions")
    public RegionsResource getRegionsResource() throws IOException {
        return new RegionsResource(this);
    }

    @Path(value="scanner")
    public ScannerResource getScannerResource() throws IOException {
        return new ScannerResource(this);
    }

    @Path(value="schema")
    public SchemaResource getSchemaResource() throws IOException {
        return new SchemaResource(this);
    }

    @Path(value="multiget")
    public MultiRowResource getMultipleRowResource(@QueryParam(value="v") String versions) throws IOException {
        return new MultiRowResource(this, versions);
    }

    @Path(value="{rowspec: [^*]+}")
    public RowResource getRowResource(@PathParam(value="rowspec") @Encoded String rowspec, @QueryParam(value="v") String versions, @QueryParam(value="check") String check) throws IOException {
        return new RowResource(this, rowspec, versions, check);
    }

    @Path(value="{suffixglobbingspec: .*\\*/.+}")
    public RowResource getRowResourceWithSuffixGlobbing(@PathParam(value="suffixglobbingspec") @Encoded String suffixglobbingspec, @QueryParam(value="v") String versions, @QueryParam(value="check") String check) throws IOException {
        return new RowResource(this, suffixglobbingspec, versions, check);
    }

    @Path(value="{scanspec: .*[*]$}")
    public TableScanResource getScanResource(@Context UriInfo uriInfo, @PathParam(value="scanspec") String scanSpec, @HeaderParam(value="Accept") String contentType, @DefaultValue(value="2147483647") @QueryParam(value="limit") int userRequestedLimit, @DefaultValue(value="") @QueryParam(value="startrow") String startRow, @DefaultValue(value="") @QueryParam(value="endrow") String endRow, @DefaultValue(value="") @QueryParam(value="column") List<String> column, @DefaultValue(value="1") @QueryParam(value="maxversions") int maxVersions, @DefaultValue(value="-1") @QueryParam(value="batchsize") int batchSize, @DefaultValue(value="0") @QueryParam(value="starttime") long startTime, @DefaultValue(value="9223372036854775807") @QueryParam(value="endtime") long endTime, @DefaultValue(value="true") @QueryParam(value="batchsize") boolean cacheBlocks) {
        try {
            PrefixFilter filter = null;
            if (scanSpec.indexOf(42) > 0) {
                String prefix = scanSpec.substring(0, scanSpec.indexOf(42));
                filter = new PrefixFilter(Bytes.toBytes((String)prefix));
            }
            LOG.debug((Object)("Query parameters  : Table Name = > " + this.table + " Start Row => " + startRow + " End Row => " + endRow + " Columns => " + column + " Start Time => " + startTime + " End Time => " + endTime + " Cache Blocks => " + cacheBlocks + " Max Versions => " + maxVersions + " Batch Size => " + batchSize));
            HTableInterface hTable = RESTServlet.getInstance().getTable(this.table);
            Scan tableScan = new Scan();
            tableScan.setBatch(batchSize);
            tableScan.setMaxVersions(maxVersions);
            tableScan.setTimeRange(startTime, endTime);
            tableScan.setStartRow(Bytes.toBytes((String)startRow));
            tableScan.setStopRow(Bytes.toBytes((String)endRow));
            for (String csplit : column) {
                String[] familysplit = csplit.trim().split(":");
                if (familysplit.length == 2) {
                    if (familysplit[1].length() > 0) {
                        LOG.debug((Object)("Scan family and column : " + familysplit[0] + "  " + familysplit[1]));
                        tableScan.addColumn(Bytes.toBytes((String)familysplit[0]), Bytes.toBytes((String)familysplit[1]));
                        continue;
                    }
                    tableScan.addFamily(Bytes.toBytes((String)familysplit[0]));
                    LOG.debug((Object)("Scan family : " + familysplit[0] + " and empty qualifier."));
                    tableScan.addColumn(Bytes.toBytes((String)familysplit[0]), null);
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)familysplit[0])) continue;
                LOG.debug((Object)("Scan family : " + familysplit[0]));
                tableScan.addFamily(Bytes.toBytes((String)familysplit[0]));
            }
            if (filter != null) {
                tableScan.setFilter((Filter)filter);
            }
            int fetchSize = this.servlet.getConfiguration().getInt("hbase.rest.scan.fetchsize", 10);
            tableScan.setCaching(fetchSize);
            return new TableScanResource(hTable.getScanner(tableScan), userRequestedLimit);
        }
        catch (Exception exp) {
            this.servlet.getMetrics().incrementFailedScanRequests(1);
            this.processException(exp);
            LOG.warn((Object)exp);
            return null;
        }
    }
}

