/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseZKTestingUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ZKReplicationQueueStorageForMigration;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.zookeeper.KeeperException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestZKReplicationQueueStorage {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKReplicationQueueStorage.class);
    private static final HBaseZKTestingUtil UTIL = new HBaseZKTestingUtil();
    private ZKWatcher zk;
    private ZKReplicationQueueStorageForMigration storage;
    @Rule
    public final TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws IOException {
        UTIL.shutdownMiniZKCluster();
    }

    @Before
    public void setUp() throws IOException {
        Configuration conf = UTIL.getConfiguration();
        conf.set("zookeeper.znode.replication", this.name.getMethodName());
        this.zk = new ZKWatcher(conf, this.name.getMethodName(), null);
        this.storage = new ZKReplicationQueueStorageForMigration(this.zk, conf);
    }

    @After
    public void tearDown() throws Exception {
        ZKUtil.deleteNodeRecursively((ZKWatcher)this.zk, (String)this.storage.replicationZNode);
        Closeables.close((Closeable)this.zk, (boolean)true);
    }

    public static void mockQueuesData(ZKReplicationQueueStorageForMigration storage, int nServers, String peerId, ServerName deadServer) throws KeeperException {
        ZKWatcher zk = storage.zookeeper;
        for (int i = 0; i < nServers; ++i) {
            ServerName sn = ServerName.valueOf((String)("test-hbase-" + i), (int)12345, (long)EnvironmentEdgeManager.currentTime());
            String rsZNode = ZNodePaths.joinZNode((String)storage.getQueuesZNode(), (String[])new String[]{sn.toString()});
            String peerZNode = ZNodePaths.joinZNode((String)rsZNode, (String[])new String[]{peerId});
            ZKUtil.createWithParents((ZKWatcher)zk, (String)peerZNode);
            for (int j = 0; j < i; ++j) {
                String wal = ZNodePaths.joinZNode((String)peerZNode, (String[])new String[]{sn.toString() + "." + j});
                ZKUtil.createSetData((ZKWatcher)zk, (String)wal, (byte[])ZKUtil.positionToByteArray((long)j));
            }
            String deadServerPeerZNode = ZNodePaths.joinZNode((String)rsZNode, (String[])new String[]{peerId + "-" + deadServer});
            ZKUtil.createWithParents((ZKWatcher)zk, (String)deadServerPeerZNode);
            for (int j = 0; j < i; ++j) {
                String wal = ZNodePaths.joinZNode((String)deadServerPeerZNode, (String[])new String[]{deadServer.toString() + "." + j});
                if (j > 0) {
                    ZKUtil.createSetData((ZKWatcher)zk, (String)wal, (byte[])ZKUtil.positionToByteArray((long)j));
                    continue;
                }
                ZKUtil.createWithParents((ZKWatcher)zk, (String)wal);
            }
        }
        ZKUtil.createWithParents((ZKWatcher)zk, (String)ZNodePaths.joinZNode((String)storage.getQueuesZNode(), (String[])new String[]{deadServer.toString()}));
    }

    private static String getLastPushedSeqIdZNode(String regionsZNode, String encodedName, String peerId) {
        return ZNodePaths.joinZNode((String)regionsZNode, (String[])new String[]{encodedName.substring(0, 2), encodedName.substring(2, 4), encodedName.substring(4) + "-" + peerId});
    }

    public static Map<String, Set<String>> mockLastPushedSeqIds(ZKReplicationQueueStorageForMigration storage, String peerId1, String peerId2, int nRegions, int emptyLevel1Count, int emptyLevel2Count) throws KeeperException {
        ZKWatcher zk = storage.zookeeper;
        HashMap<String, Set<String>> name2PeerIds = new HashMap<String, Set<String>>();
        byte[] bytes = new byte[32];
        for (int i = 0; i < nRegions; ++i) {
            ThreadLocalRandom.current().nextBytes(bytes);
            String encodeName = MD5Hash.getMD5AsHex((byte[])bytes);
            String znode1 = TestZKReplicationQueueStorage.getLastPushedSeqIdZNode(storage.getRegionsZNode(), encodeName, peerId1);
            ZKUtil.createSetData((ZKWatcher)zk, (String)znode1, (byte[])ZKUtil.positionToByteArray((long)1L));
            String znode2 = TestZKReplicationQueueStorage.getLastPushedSeqIdZNode(storage.getRegionsZNode(), encodeName, peerId2);
            ZKUtil.createSetData((ZKWatcher)zk, (String)znode2, (byte[])ZKUtil.positionToByteArray((long)2L));
            name2PeerIds.put(encodeName, Sets.newHashSet((Object[])new String[]{peerId1, peerId2}));
        }
        int addedEmptyZNodes = 0;
        for (int i = 0; i < 256; ++i) {
            String level1ZNode = ZNodePaths.joinZNode((String)storage.getRegionsZNode(), (String[])new String[]{String.format("%02x", i)});
            if (ZKUtil.checkExists((ZKWatcher)zk, (String)level1ZNode) != -1) continue;
            ZKUtil.createWithParents((ZKWatcher)zk, (String)level1ZNode);
            if (++addedEmptyZNodes <= emptyLevel2Count) {
                ZKUtil.createWithParents((ZKWatcher)zk, (String)ZNodePaths.joinZNode((String)level1ZNode, (String[])new String[]{"ab"}));
            }
            if (addedEmptyZNodes >= emptyLevel1Count + emptyLevel2Count) break;
        }
        return name2PeerIds;
    }

    public static void mockHFileRefs(ZKReplicationQueueStorageForMigration storage, int nPeers) throws KeeperException {
        ZKWatcher zk = storage.zookeeper;
        for (int i = 0; i < nPeers; ++i) {
            String peerId = "peer_" + i;
            ZKUtil.createWithParents((ZKWatcher)zk, (String)ZNodePaths.joinZNode((String)storage.getHfileRefsZNode(), (String[])new String[]{peerId}));
            for (int j = 0; j < i; ++j) {
                ZKUtil.createWithParents((ZKWatcher)zk, (String)ZNodePaths.joinZNode((String)storage.getHfileRefsZNode(), (String[])new String[]{peerId, "hfile-" + j}));
            }
        }
    }

    @Test
    public void testDeleteAllData() throws Exception {
        Assert.assertFalse((boolean)this.storage.hasData());
        ZKUtil.createWithParents((ZKWatcher)this.zk, (String)this.storage.getQueuesZNode());
        Assert.assertTrue((boolean)this.storage.hasData());
        this.storage.deleteAllData();
        Assert.assertFalse((boolean)this.storage.hasData());
    }

    @Test
    public void testEmptyIter() throws Exception {
        ZKUtil.createWithParents((ZKWatcher)this.zk, (String)this.storage.getQueuesZNode());
        ZKUtil.createWithParents((ZKWatcher)this.zk, (String)this.storage.getRegionsZNode());
        ZKUtil.createWithParents((ZKWatcher)this.zk, (String)this.storage.getHfileRefsZNode());
        Assert.assertNull((Object)this.storage.listAllQueues().next());
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)this.zk, (String)this.storage.getQueuesZNode()));
        Assert.assertNull((Object)this.storage.listAllLastPushedSeqIds().next());
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)this.zk, (String)this.storage.getRegionsZNode()));
        Assert.assertNull((Object)this.storage.listAllHFileRefs().next());
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)this.zk, (String)this.storage.getHfileRefsZNode()));
    }

    @Test
    public void testListAllQueues() throws Exception {
        String peerId = "1";
        ServerName deadServer = ServerName.valueOf((String)"test-hbase-dead", (int)12345, (long)EnvironmentEdgeManager.currentTime());
        int nServers = 10;
        TestZKReplicationQueueStorage.mockQueuesData(this.storage, nServers, peerId, deadServer);
        ZKReplicationQueueStorageForMigration.MigrationIterator iter = this.storage.listAllQueues();
        ServerName previousServerName = null;
        for (int i = 0; i < nServers + 1; ++i) {
            ServerName sn;
            Pair pair = (Pair)iter.next();
            Assert.assertNotNull((Object)pair);
            if (previousServerName != null) {
                Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)this.zk, (String)ZNodePaths.joinZNode((String)this.storage.getQueuesZNode(), (String[])new String[]{previousServerName.toString()})));
            }
            previousServerName = sn = (ServerName)pair.getFirst();
            if (sn.equals((Object)deadServer)) {
                MatcherAssert.assertThat((Object)pair.getSecond(), (Matcher)Matchers.empty());
                continue;
            }
            Assert.assertEquals((long)2L, (long)((List)pair.getSecond()).size());
            int n = Integer.parseInt((String)Iterables.getLast((Iterable)Splitter.on((char)'-').split((CharSequence)sn.getHostname())));
            ZKReplicationQueueStorageForMigration.ZkReplicationQueueData data0 = (ZKReplicationQueueStorageForMigration.ZkReplicationQueueData)((List)pair.getSecond()).get(0);
            Assert.assertEquals((Object)peerId, (Object)data0.getQueueId().getPeerId());
            Assert.assertEquals((Object)sn, (Object)data0.getQueueId().getServerName());
            Assert.assertEquals((long)n, (long)data0.getWalOffsets().size());
            for (int j = 0; j < n; ++j) {
                Assert.assertEquals((long)j, (long)((Long)data0.getWalOffsets().get((data0.getQueueId().isRecovered() ? deadServer.toString() : sn.toString()) + "." + j)).intValue());
            }
            ZKReplicationQueueStorageForMigration.ZkReplicationQueueData data1 = (ZKReplicationQueueStorageForMigration.ZkReplicationQueueData)((List)pair.getSecond()).get(1);
            Assert.assertEquals((Object)peerId, (Object)data1.getQueueId().getPeerId());
            Assert.assertEquals((Object)sn, (Object)data1.getQueueId().getServerName());
            Assert.assertEquals((long)n, (long)data1.getWalOffsets().size());
            for (int j = 0; j < n; ++j) {
                Assert.assertEquals((long)j, (long)((Long)data1.getWalOffsets().get((data1.getQueueId().isRecovered() ? deadServer.toString() : sn.toString()) + "." + j)).intValue());
            }
            if (data0.getQueueId().getSourceServerName().isPresent()) {
                Assert.assertEquals((Object)deadServer, data0.getQueueId().getSourceServerName().get());
                Assert.assertFalse((boolean)data1.getQueueId().getSourceServerName().isPresent());
                continue;
            }
            Assert.assertEquals((Object)deadServer, data1.getQueueId().getSourceServerName().get());
        }
        Assert.assertNull((Object)iter.next());
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)this.zk, (String)this.storage.getQueuesZNode()));
    }

    @Test
    public void testListAllLastPushedSeqIds() throws Exception {
        List list;
        String peerId1 = "1";
        String peerId2 = "2";
        Map<String, Set<String>> name2PeerIds = TestZKReplicationQueueStorage.mockLastPushedSeqIds(this.storage, peerId1, peerId2, 100, 10, 10);
        ZKReplicationQueueStorageForMigration.MigrationIterator iter = this.storage.listAllLastPushedSeqIds();
        int emptyListCount = 0;
        while ((list = (List)iter.next()) != null) {
            if (list.isEmpty()) {
                ++emptyListCount;
                continue;
            }
            for (ZKReplicationQueueStorageForMigration.ZkLastPushedSeqId seqId : list) {
                name2PeerIds.get(seqId.getEncodedRegionName()).remove(seqId.getPeerId());
                if (seqId.getPeerId().equals(peerId1)) {
                    Assert.assertEquals((long)1L, (long)seqId.getLastPushedSeqId());
                    continue;
                }
                Assert.assertEquals((long)2L, (long)seqId.getLastPushedSeqId());
            }
        }
        Assert.assertEquals((long)10L, (long)emptyListCount);
        name2PeerIds.forEach((encodedRegionName, peerIds) -> MatcherAssert.assertThat((String)(encodedRegionName + " still has unmigrated peers"), (Object)peerIds, (Matcher)Matchers.empty()));
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)this.zk, (String)this.storage.getRegionsZNode()));
    }

    @Test
    public void testListAllHFileRefs() throws Exception {
        int nPeers = 10;
        TestZKReplicationQueueStorage.mockHFileRefs(this.storage, nPeers);
        ZKReplicationQueueStorageForMigration.MigrationIterator iter = this.storage.listAllHFileRefs();
        String previousPeerId = null;
        for (int i = 0; i < nPeers; ++i) {
            String peerId;
            Pair pair = (Pair)iter.next();
            if (previousPeerId != null) {
                Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)this.zk, (String)ZNodePaths.joinZNode((String)this.storage.getHfileRefsZNode(), (String[])new String[]{previousPeerId})));
            }
            previousPeerId = peerId = (String)pair.getFirst();
            int index = Integer.parseInt((String)Iterables.getLast((Iterable)Splitter.on((char)'_').split((CharSequence)peerId)));
            Assert.assertEquals((long)index, (long)((List)pair.getSecond()).size());
        }
        Assert.assertNull((Object)iter.next());
        Assert.assertEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)this.zk, (String)this.storage.getHfileRefsZNode()));
    }
}

