/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseZKTestingUtil;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorageTestBase;
import org.apache.hadoop.hbase.replication.ZKReplicationPeerStorage;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.zookeeper.KeeperException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestZKReplicationPeerStorage
extends ReplicationPeerStorageTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKReplicationPeerStorage.class);
    private static final HBaseZKTestingUtil UTIL = new HBaseZKTestingUtil();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniZKCluster();
        STORAGE = new ZKReplicationPeerStorage(UTIL.getZooKeeperWatcher(), UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniZKCluster();
    }

    @Override
    protected void removePeerSyncRelicationState(String peerId) throws Exception {
        ZKReplicationPeerStorage storage = (ZKReplicationPeerStorage)STORAGE;
        ZKUtil.deleteNode((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)storage.getSyncReplicationStateNode(peerId));
        ZKUtil.deleteNode((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)storage.getNewSyncReplicationStateNode(peerId));
    }

    @Override
    protected void assertPeerSyncReplicationStateCreate(String peerId) throws Exception {
        ZKReplicationPeerStorage storage = (ZKReplicationPeerStorage)STORAGE;
        Assert.assertNotEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)storage.getSyncReplicationStateNode(peerId)));
        Assert.assertNotEquals((long)-1L, (long)ZKUtil.checkExists((ZKWatcher)UTIL.getZooKeeperWatcher(), (String)storage.getNewSyncReplicationStateNode(peerId)));
    }

    @Override
    protected void assertPeerNameControlException(ReplicationException e) {
        MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.instanceOf(KeeperException.NodeExistsException.class));
    }
}

