/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerImpl;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.SyncReplicationState;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestReplicationStateBasic {
    private static final Logger LOG = LoggerFactory.getLogger(TestReplicationStateBasic.class);
    protected ServerName server1 = ServerName.valueOf((String)"hostname1.example.org", (int)1234, (long)12345L);
    protected ServerName server2 = ServerName.valueOf((String)"hostname2.example.org", (int)1234, (long)12345L);
    protected ServerName server3 = ServerName.valueOf((String)"hostname3.example.org", (int)1234, (long)12345L);
    protected ReplicationPeers rp;
    protected static final String ID_ONE = "1";
    protected static final String ID_TWO = "2";
    protected static String KEY_ONE;
    protected static String KEY_TWO;
    protected String OUR_KEY;
    protected static int zkTimeoutCount;
    protected static final int ZK_MAX_COUNT = 300;
    protected static final int ZK_SLEEP_INTERVAL = 100;

    @Test
    public void testReplicationPeers() throws Exception {
        this.rp.init();
        try {
            this.rp.getPeerStorage().setPeerState("bogus", true);
            Assert.fail((String)"Should have thrown an IllegalArgumentException when passed a bogus peerId");
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        try {
            this.rp.getPeerStorage().setPeerState("bogus", false);
            Assert.fail((String)"Should have thrown an IllegalArgumentException when passed a bogus peerId");
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)this.rp.addPeer("bogus"));
            Assert.fail((String)"Should have thrown an ReplicationException when passed a bogus peerId");
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
        this.assertNumberOfPeers(0);
        this.rp.getPeerStorage().addPeer(ID_ONE, ReplicationPeerConfig.newBuilder().setClusterKey(KEY_ONE).build(), true, SyncReplicationState.NONE);
        this.assertNumberOfPeers(1);
        this.rp.getPeerStorage().addPeer(ID_TWO, ReplicationPeerConfig.newBuilder().setClusterKey(KEY_TWO).build(), true, SyncReplicationState.NONE);
        this.assertNumberOfPeers(2);
        Assert.assertEquals((Object)KEY_ONE, (Object)ZKConfig.getZooKeeperClusterKey((Configuration)ReplicationUtils.getPeerClusterConfiguration((ReplicationPeerConfig)this.rp.getPeerStorage().getPeerConfig(ID_ONE), (Configuration)this.rp.getConf())));
        this.rp.getPeerStorage().removePeer(ID_ONE);
        this.rp.removePeer(ID_ONE);
        this.assertNumberOfPeers(1);
        this.rp.getPeerStorage().addPeer(ID_ONE, ReplicationPeerConfig.newBuilder().setClusterKey(KEY_ONE).build(), true, SyncReplicationState.NONE);
        this.rp.addPeer(ID_ONE);
        this.assertNumberOfPeers(2);
        Assert.assertTrue((boolean)this.rp.getPeer(ID_ONE).isPeerEnabled());
        this.rp.getPeerStorage().setPeerState(ID_ONE, false);
        ReplicationPeerImpl peer = this.rp.getPeer(ID_ONE);
        this.rp.refreshPeerState(peer.getId());
        Assert.assertEquals((Object)ReplicationPeer.PeerState.DISABLED, (Object)peer.getPeerState());
        this.assertConnectedPeerStatus(false, ID_ONE);
        this.rp.getPeerStorage().setPeerState(ID_ONE, true);
        this.rp.refreshPeerState(peer.getId());
        Assert.assertEquals((Object)ReplicationPeer.PeerState.ENABLED, (Object)peer.getPeerState());
        this.assertConnectedPeerStatus(true, ID_ONE);
        this.rp.removePeer(ID_ONE);
        this.assertNumberOfPeers(2);
    }

    private void assertConnectedPeerStatus(boolean status, String peerId) throws Exception {
        if (status != this.rp.getPeerStorage().isPeerEnabled(peerId)) {
            Assert.fail((String)("ConnectedPeerStatus was " + !status + " but expected " + status + " in ZK"));
        }
        while (status != this.rp.getPeer(peerId).isPeerEnabled()) {
            if (zkTimeoutCount < 300) {
                LOG.debug("ConnectedPeerStatus was " + !status + " but expected " + status + ", sleeping and trying again.");
                Thread.sleep(100L);
                continue;
            }
            Assert.fail((String)("Timed out waiting for ConnectedPeerStatus to be " + status));
        }
        return;
    }

    private void assertNumberOfPeers(int total) throws ReplicationException {
        Assert.assertEquals((long)total, (long)this.rp.getPeerStorage().listPeerIds().size());
    }
}

