/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.replication.FSReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorageTestBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.RotateFile;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestFSReplicationPeerStorage
extends ReplicationPeerStorageTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFSReplicationPeerStorage.class);
    private static final HBaseCommonTestingUtil UTIL = new HBaseCommonTestingUtil();
    private static FileSystem FS;
    private static Path DIR;

    @BeforeClass
    public static void setUp() throws Exception {
        DIR = UTIL.getDataTestDir("test_fs_peer_storage");
        CommonFSUtils.setRootDir((Configuration)UTIL.getConfiguration(), (Path)DIR);
        FS = FileSystem.get((Configuration)UTIL.getConfiguration());
        STORAGE = new FSReplicationPeerStorage(FS, UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.cleanupTestDir();
    }

    @Override
    protected void removePeerSyncRelicationState(String peerId) throws Exception {
        FSReplicationPeerStorage storage = (FSReplicationPeerStorage)STORAGE;
        Path peerDir = storage.getPeerDir(peerId);
        RotateFile file = new RotateFile(FS, peerDir, "sync-rep-state", 1024L);
        file.read();
        file.delete();
    }

    @Override
    protected void assertPeerSyncReplicationStateCreate(String peerId) throws Exception {
        FSReplicationPeerStorage storage = (FSReplicationPeerStorage)STORAGE;
        Path peerDir = storage.getPeerDir(peerId);
        RotateFile file = new RotateFile(FS, peerDir, "sync-rep-state", 1024L);
        Assert.assertNotNull((Object)file.read());
    }

    @Override
    protected void assertPeerNameControlException(ReplicationException e) {
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.endsWith((String)"peer already exists"));
    }
}

