/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ZKReplicationQueueStorage;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MD5Hash;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.zookeeper.KeeperException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestZKReplicationQueueStorage {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestZKReplicationQueueStorage.class);
    private static final HBaseZKTestingUtility UTIL = new HBaseZKTestingUtility();
    private static ZKReplicationQueueStorage STORAGE;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniZKCluster();
        STORAGE = new ZKReplicationQueueStorage(UTIL.getZooKeeperWatcher(), UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() throws IOException {
        UTIL.shutdownMiniZKCluster();
    }

    @After
    public void tearDownAfterTest() throws ReplicationException, KeeperException, IOException {
        for (ServerName serverName : STORAGE.getListOfReplicators()) {
            for (String queue : STORAGE.getAllQueues(serverName)) {
                STORAGE.removeQueue(serverName, queue);
            }
            STORAGE.removeReplicatorIfQueueIsEmpty(serverName);
        }
        for (String peerId : STORAGE.getAllPeersFromHFileRefsQueue()) {
            STORAGE.removePeerFromHFileRefs(peerId);
        }
    }

    private ServerName getServerName(int i) {
        return ServerName.valueOf((String)"127.0.0.1", (int)(8000 + i), (long)(10000 + i));
    }

    @Test
    public void testReplicator() throws ReplicationException {
        int i;
        Assert.assertTrue((boolean)STORAGE.getListOfReplicators().isEmpty());
        String queueId = "1";
        for (int i2 = 0; i2 < 10; ++i2) {
            STORAGE.addWAL(this.getServerName(i2), queueId, "file" + i2);
        }
        List replicators = STORAGE.getListOfReplicators();
        Assert.assertEquals((long)10L, (long)replicators.size());
        for (i = 0; i < 10; ++i) {
            MatcherAssert.assertThat((Object)replicators, (Matcher)CoreMatchers.hasItems((Object[])new ServerName[]{this.getServerName(i)}));
        }
        for (i = 0; i < 5; ++i) {
            STORAGE.removeQueue(this.getServerName(i), queueId);
        }
        for (i = 0; i < 10; ++i) {
            STORAGE.removeReplicatorIfQueueIsEmpty(this.getServerName(i));
        }
        replicators = STORAGE.getListOfReplicators();
        Assert.assertEquals((long)5L, (long)replicators.size());
        for (i = 5; i < 10; ++i) {
            MatcherAssert.assertThat((Object)replicators, (Matcher)CoreMatchers.hasItems((Object[])new ServerName[]{this.getServerName(i)}));
        }
    }

    private String getFileName(String base, int i) {
        return String.format(base + "-%04d", i);
    }

    @Test
    public void testAddRemoveLog() throws ReplicationException {
        int i;
        ServerName serverName1 = ServerName.valueOf((String)"127.0.0.1", (int)8000, (long)10000L);
        Assert.assertTrue((boolean)STORAGE.getAllQueues(serverName1).isEmpty());
        String queue1 = "1";
        String queue2 = "2";
        for (int i2 = 0; i2 < 10; ++i2) {
            STORAGE.addWAL(serverName1, queue1, this.getFileName("file1", i2));
            STORAGE.addWAL(serverName1, queue2, this.getFileName("file2", i2));
        }
        List queueIds = STORAGE.getAllQueues(serverName1);
        Assert.assertEquals((long)2L, (long)queueIds.size());
        MatcherAssert.assertThat((Object)queueIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"1", "2"}));
        List wals1 = STORAGE.getWALsInQueue(serverName1, queue1);
        List wals2 = STORAGE.getWALsInQueue(serverName1, queue2);
        Assert.assertEquals((long)10L, (long)wals1.size());
        Assert.assertEquals((long)10L, (long)wals2.size());
        for (i = 0; i < 10; ++i) {
            MatcherAssert.assertThat((Object)wals1, (Matcher)CoreMatchers.hasItems((Object[])new String[]{this.getFileName("file1", i)}));
            MatcherAssert.assertThat((Object)wals2, (Matcher)CoreMatchers.hasItems((Object[])new String[]{this.getFileName("file2", i)}));
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)0L, (long)STORAGE.getWALPosition(serverName1, queue1, this.getFileName("file1", i)));
            Assert.assertEquals((long)0L, (long)STORAGE.getWALPosition(serverName1, queue2, this.getFileName("file2", i)));
            STORAGE.setWALPosition(serverName1, queue1, this.getFileName("file1", i), (long)((i + 1) * 100), Collections.emptyMap());
            STORAGE.setWALPosition(serverName1, queue2, this.getFileName("file2", i), (long)((i + 1) * 100 + 10), Collections.emptyMap());
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)((i + 1) * 100), (long)STORAGE.getWALPosition(serverName1, queue1, this.getFileName("file1", i)));
            Assert.assertEquals((long)((i + 1) * 100 + 10), (long)STORAGE.getWALPosition(serverName1, queue2, this.getFileName("file2", i)));
        }
        for (i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                STORAGE.removeWAL(serverName1, queue1, this.getFileName("file1", i));
                continue;
            }
            STORAGE.removeWAL(serverName1, queue2, this.getFileName("file2", i));
        }
        queueIds = STORAGE.getAllQueues(serverName1);
        Assert.assertEquals((long)2L, (long)queueIds.size());
        MatcherAssert.assertThat((Object)queueIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"1", "2"}));
        ServerName serverName2 = ServerName.valueOf((String)"127.0.0.1", (int)8001, (long)10001L);
        Pair peer1 = STORAGE.claimQueue(serverName1, "1", serverName2);
        Assert.assertEquals((Object)("1-" + serverName1.getServerName()), (Object)peer1.getFirst());
        Assert.assertEquals((long)5L, (long)((SortedSet)peer1.getSecond()).size());
        int i3 = 1;
        for (String wal : (SortedSet)peer1.getSecond()) {
            Assert.assertEquals((Object)this.getFileName("file1", i3), (Object)wal);
            Assert.assertEquals((long)((i3 + 1) * 100), (long)STORAGE.getWALPosition(serverName2, (String)peer1.getFirst(), this.getFileName("file1", i3)));
            i3 += 2;
        }
        queueIds = STORAGE.getAllQueues(serverName1);
        Assert.assertEquals((long)1L, (long)queueIds.size());
        MatcherAssert.assertThat((Object)queueIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"2"}));
        wals2 = STORAGE.getWALsInQueue(serverName1, queue2);
        Assert.assertEquals((long)5L, (long)wals2.size());
        for (i3 = 0; i3 < 10; i3 += 2) {
            MatcherAssert.assertThat((Object)wals2, (Matcher)CoreMatchers.hasItems((Object[])new String[]{this.getFileName("file2", i3)}));
        }
        queueIds = STORAGE.getAllQueues(serverName2);
        Assert.assertEquals((long)1L, (long)queueIds.size());
        MatcherAssert.assertThat((Object)queueIds, (Matcher)CoreMatchers.hasItems((Object[])new String[]{(String)peer1.getFirst()}));
        wals1 = STORAGE.getWALsInQueue(serverName2, (String)peer1.getFirst());
        Assert.assertEquals((long)5L, (long)wals1.size());
        for (i3 = 1; i3 < 10; i3 += 2) {
            MatcherAssert.assertThat((Object)wals1, (Matcher)CoreMatchers.hasItems((Object[])new String[]{this.getFileName("file1", i3)}));
        }
        Set allWals = STORAGE.getAllWALs();
        Assert.assertEquals((long)10L, (long)allWals.size());
        for (i3 = 0; i3 < 10; ++i3) {
            MatcherAssert.assertThat((Object)allWals, (Matcher)CoreMatchers.hasItems((Object[])new String[]{i3 % 2 == 0 ? this.getFileName("file2", i3) : this.getFileName("file1", i3)}));
        }
    }

    @Test
    public void testClaimQueueChangeCversion() throws ReplicationException, KeeperException {
        ServerName serverName1 = ServerName.valueOf((String)"127.0.0.1", (int)8000, (long)10000L);
        STORAGE.addWAL(serverName1, "1", "file");
        STORAGE.addWAL(serverName1, "2", "file");
        ServerName serverName2 = ServerName.valueOf((String)"127.0.0.1", (int)8001, (long)10001L);
        STORAGE.addWAL(serverName2, "1", "file");
        STORAGE.addWAL(serverName2, "2", "file");
        int v0 = STORAGE.getQueuesZNodeCversion();
        STORAGE.claimQueue(serverName1, "1", serverName2);
        int v1 = STORAGE.getQueuesZNodeCversion();
        Assert.assertTrue((v1 > v0 ? 1 : 0) != 0);
        STORAGE.claimQueue(serverName1, "2", serverName2);
        int v2 = STORAGE.getQueuesZNodeCversion();
        Assert.assertTrue((v2 > v1 ? 1 : 0) != 0);
    }

    private ZKReplicationQueueStorage createWithUnstableVersion() throws IOException {
        return new ZKReplicationQueueStorage(UTIL.getZooKeeperWatcher(), UTIL.getConfiguration()){
            private int called;
            private int getLastSeqIdOpIndex;
            {
                this.called = 0;
                this.getLastSeqIdOpIndex = 0;
            }

            protected int getQueuesZNodeCversion() throws KeeperException {
                if (this.called < 4) {
                    ++this.called;
                }
                return this.called;
            }

            protected Pair<Long, Integer> getLastSequenceIdWithVersion(String encodedRegionName, String peerId) throws KeeperException {
                Pair oldPair = super.getLastSequenceIdWithVersion(encodedRegionName, peerId);
                if (this.getLastSeqIdOpIndex < 100) {
                    String path = this.getSerialReplicationRegionPeerNode(encodedRegionName, peerId);
                    ZKUtil.createWithParents((ZKWatcher)this.zookeeper, (String)path);
                    ZKUtil.setData((ZKWatcher)this.zookeeper, (String)path, (byte[])ZKUtil.positionToByteArray((long)100L));
                }
                ++this.getLastSeqIdOpIndex;
                return oldPair;
            }
        };
    }

    @Test
    public void testGetAllWALsCversionChange() throws IOException, ReplicationException {
        ZKReplicationQueueStorage storage = this.createWithUnstableVersion();
        storage.addWAL(this.getServerName(0), "1", "file");
        Set allWals = storage.getAllWALs();
        Assert.assertEquals((long)1L, (long)allWals.size());
        MatcherAssert.assertThat((Object)allWals, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"file"}));
    }

    @Test
    public void testGetAllHFileRefsCversionChange() throws IOException, ReplicationException {
        ZKReplicationQueueStorage storage = this.createWithUnstableVersion();
        storage.addPeerToHFileRefs("1");
        Path p = new Path("/test");
        storage.addHFileRefs("1", Arrays.asList(Pair.newPair((Object)p, (Object)p)));
        Set allHFileRefs = storage.getAllHFileRefs();
        Assert.assertEquals((long)1L, (long)allHFileRefs.size());
        MatcherAssert.assertThat((Object)allHFileRefs, (Matcher)CoreMatchers.hasItems((Object[])new String[]{"test"}));
    }

    @Test
    public void testSetWALPositionBadVersion() throws IOException, ReplicationException {
        ZKReplicationQueueStorage storage = this.createWithUnstableVersion();
        ServerName serverName1 = ServerName.valueOf((String)"128.0.0.1", (int)8000, (long)10000L);
        Assert.assertTrue((boolean)storage.getAllQueues(serverName1).isEmpty());
        String queue1 = "1";
        String fileName = this.getFileName("file1", 0);
        String encodedRegionName = "31d9792f4435b99d9fb1016f6fbc8dc6";
        storage.addWAL(serverName1, queue1, fileName);
        List wals1 = storage.getWALsInQueue(serverName1, queue1);
        Assert.assertEquals((long)1L, (long)wals1.size());
        Assert.assertEquals((long)0L, (long)storage.getWALPosition(serverName1, queue1, fileName));
        storage.setWALPosition(serverName1, queue1, fileName, 100L, (Map)ImmutableMap.of((Object)encodedRegionName, (Object)120L));
        Assert.assertEquals((long)100L, (long)storage.getWALPosition(serverName1, queue1, fileName));
        Assert.assertEquals((long)120L, (long)storage.getLastSequenceId(encodedRegionName, queue1));
    }

    @Test
    public void testRegionsZNodeLayout() throws Exception {
        String peerId = "1";
        String encodedRegionName = "31d9792f4435b99d9fb1016f6fbc8dc7";
        String expectedPath = "/hbase/replication/regions/31/d9/792f4435b99d9fb1016f6fbc8dc7-" + peerId;
        String path = STORAGE.getSerialReplicationRegionPeerNode(encodedRegionName, peerId);
        Assert.assertEquals((Object)expectedPath, (Object)path);
    }

    @Test
    public void testRemoveAllLastPushedSeqIdsForPeer() throws Exception {
        String encodedRegionName;
        int i;
        String peerId = "1";
        String peerIdToDelete = "2";
        for (i = 0; i < 100; ++i) {
            encodedRegionName = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((int)i));
            STORAGE.setLastSequenceIds(peerId, (Map)ImmutableMap.of((Object)encodedRegionName, (Object)i));
            STORAGE.setLastSequenceIds(peerIdToDelete, (Map)ImmutableMap.of((Object)encodedRegionName, (Object)i));
        }
        for (i = 0; i < 100; ++i) {
            encodedRegionName = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((int)i));
            Assert.assertEquals((long)i, (long)STORAGE.getLastSequenceId(encodedRegionName, peerId));
            Assert.assertEquals((long)i, (long)STORAGE.getLastSequenceId(encodedRegionName, peerIdToDelete));
        }
        STORAGE.removeLastSequenceIds(peerIdToDelete);
        for (i = 0; i < 100; ++i) {
            encodedRegionName = MD5Hash.getMD5AsHex((byte[])Bytes.toBytes((int)i));
            Assert.assertEquals((long)i, (long)STORAGE.getLastSequenceId(encodedRegionName, peerId));
            Assert.assertEquals((long)-1L, (long)STORAGE.getLastSequenceId(encodedRegionName, peerIdToDelete));
        }
    }
}

