/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationStorageFactory;
import org.apache.hadoop.hbase.replication.TestReplicationStateBasic;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationStateZKImpl
extends TestReplicationStateBasic {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReplicationStateZKImpl.class);
    private static Configuration conf;
    private static HBaseZKTestingUtility utility;
    private static ZKWatcher zkw;
    private static String replicationZNode;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        utility = new HBaseZKTestingUtility();
        utility.startMiniZKCluster();
        conf = utility.getConfiguration();
        conf.setBoolean("hbase.replication.bulkload.enabled", true);
        zkw = utility.getZooKeeperWatcher();
        String replicationZNodeName = conf.get("zookeeper.znode.replication", "replication");
        replicationZNode = ZNodePaths.joinZNode((String)TestReplicationStateZKImpl.zkw.getZNodePaths().baseZNode, (String)replicationZNodeName);
        KEY_ONE = TestReplicationStateZKImpl.initPeerClusterState("/hbase1");
        KEY_TWO = TestReplicationStateZKImpl.initPeerClusterState("/hbase2");
    }

    private static String initPeerClusterState(String baseZKNode) throws IOException, KeeperException {
        Configuration testConf = new Configuration(conf);
        testConf.set("zookeeper.znode.parent", baseZKNode);
        ZKWatcher zkw1 = new ZKWatcher(testConf, "test1", null);
        String fakeRs = ZNodePaths.joinZNode((String)zkw1.getZNodePaths().rsZNode, (String)"hostname1.example.org:1234");
        ZKUtil.createWithParents((ZKWatcher)zkw1, (String)fakeRs);
        ZKClusterId.setClusterId((ZKWatcher)zkw1, (ClusterId)new ClusterId());
        return ZKConfig.getZooKeeperClusterKey((Configuration)testConf);
    }

    @Before
    public void setUp() throws IOException {
        zkTimeoutCount = 0;
        this.rqs = ReplicationStorageFactory.getReplicationQueueStorage((ZKWatcher)zkw, (Configuration)conf);
        this.rp = ReplicationFactory.getReplicationPeers((FileSystem)FileSystem.get((Configuration)utility.getConfiguration()), (ZKWatcher)zkw, (Configuration)conf);
        this.OUR_KEY = ZKConfig.getZooKeeperClusterKey((Configuration)conf);
    }

    @After
    public void tearDown() throws KeeperException, IOException {
        ZKUtil.deleteNodeRecursively((ZKWatcher)zkw, (String)replicationZNode);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility.shutdownMiniZKCluster();
    }
}

