/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseZKTestingUtility;
import org.apache.hadoop.hbase.replication.CopyReplicationPeers;
import org.apache.hadoop.hbase.replication.FSReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigTestUtil;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.apache.hadoop.hbase.replication.ZKReplicationPeerStorage;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestCopyReplicationPeers {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCopyReplicationPeers.class);
    private static final HBaseZKTestingUtility UTIL = new HBaseZKTestingUtility();
    private static FileSystem FS;
    private static Path DIR;
    private static ReplicationPeerStorage SRC;
    private static ReplicationPeerStorage DST;

    @BeforeClass
    public static void setUp() throws Exception {
        DIR = UTIL.getDataTestDir("test_peer_migration");
        CommonFSUtils.setRootDir((Configuration)UTIL.getConfiguration(), (Path)DIR);
        FS = FileSystem.get((Configuration)UTIL.getConfiguration());
        UTIL.startMiniZKCluster();
        SRC = new ZKReplicationPeerStorage(UTIL.getZooKeeperWatcher(), UTIL.getConfiguration());
        DST = new FSReplicationPeerStorage(FS, UTIL.getConfiguration());
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniZKCluster();
        UTIL.cleanupTestDir();
    }

    @Test
    public void testMigrate() throws Exception {
        Assert.assertEquals((long)-1L, (long)ToolRunner.run((Tool)new CopyReplicationPeers(UTIL.getConfiguration()), (String[])new String[0]));
        int peerCount = 10;
        for (int i = 0; i < peerCount; ++i) {
            SRC.addPeer(Integer.toString(i), ReplicationPeerConfigTestUtil.getConfig((int)i), i % 2 == 0);
        }
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Tool)new CopyReplicationPeers(UTIL.getConfiguration()), (String[])new String[]{SRC.getClass().getName(), DST.getClass().getName()}));
        List peerIds = DST.listPeerIds();
        Assert.assertEquals((long)peerCount, (long)peerIds.size());
        for (String peerId : peerIds) {
            int seed = Integer.parseInt(peerId);
            ReplicationPeerConfigTestUtil.assertConfigEquals((ReplicationPeerConfig)ReplicationPeerConfigTestUtil.getConfig((int)seed), (ReplicationPeerConfig)DST.getPeerConfig(peerId));
        }
    }
}

