/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfigTestUtil;
import org.apache.hadoop.hbase.replication.ReplicationPeerStorage;
import org.junit.Assert;
import org.junit.Test;

public abstract class ReplicationPeerStorageTestBase {
    protected static ReplicationPeerStorage STORAGE;

    @Test
    public void test() throws ReplicationException {
        int i;
        int seed;
        int peerCount = 10;
        for (int i2 = 0; i2 < peerCount; ++i2) {
            STORAGE.addPeer(Integer.toString(i2), ReplicationPeerConfigTestUtil.getConfig((int)i2), i2 % 2 == 0);
        }
        List peerIds = STORAGE.listPeerIds();
        Assert.assertEquals((long)peerCount, (long)peerIds.size());
        for (String peerId : peerIds) {
            seed = Integer.parseInt(peerId);
            ReplicationPeerConfigTestUtil.assertConfigEquals((ReplicationPeerConfig)ReplicationPeerConfigTestUtil.getConfig((int)seed), (ReplicationPeerConfig)STORAGE.getPeerConfig(peerId));
        }
        for (int i3 = 0; i3 < peerCount; ++i3) {
            STORAGE.updatePeerConfig(Integer.toString(i3), ReplicationPeerConfigTestUtil.getConfig((int)(i3 + 1)));
        }
        for (String peerId : peerIds) {
            seed = Integer.parseInt(peerId);
            ReplicationPeerConfigTestUtil.assertConfigEquals((ReplicationPeerConfig)ReplicationPeerConfigTestUtil.getConfig((int)(seed + 1)), (ReplicationPeerConfig)STORAGE.getPeerConfig(peerId));
        }
        for (i = 0; i < peerCount; ++i) {
            Assert.assertEquals((Object)(i % 2 == 0 ? 1 : 0), (Object)STORAGE.isPeerEnabled(Integer.toString(i)));
        }
        for (i = 0; i < peerCount; ++i) {
            STORAGE.setPeerState(Integer.toString(i), i % 2 != 0);
        }
        for (i = 0; i < peerCount; ++i) {
            Assert.assertEquals((Object)(i % 2 != 0 ? 1 : 0), (Object)STORAGE.isPeerEnabled(Integer.toString(i)));
        }
        String toRemove = Integer.toString(peerCount / 2);
        STORAGE.removePeer(toRemove);
        peerIds = STORAGE.listPeerIds();
        Assert.assertEquals((long)(peerCount - 1), (long)peerIds.size());
        Assert.assertFalse((boolean)peerIds.contains(toRemove));
        try {
            STORAGE.getPeerConfig(toRemove);
            Assert.fail((String)"Should throw a ReplicationException when getting peer config of a removed peer");
        }
        catch (ReplicationException replicationException) {
            // empty catch block
        }
    }

    protected abstract void assertPeerNameControlException(ReplicationException var1);

    @Test
    public void testPeerNameControl() throws Exception {
        String clusterKey = "key";
        STORAGE.addPeer("6", ReplicationPeerConfig.newBuilder().setClusterKey(clusterKey).build(), true);
        try {
            ReplicationException e = (ReplicationException)Assert.assertThrows(ReplicationException.class, () -> STORAGE.addPeer("6", ReplicationPeerConfig.newBuilder().setClusterKey(clusterKey).build(), true));
            this.assertPeerNameControlException(e);
        }
        finally {
            STORAGE.removePeer("6");
        }
    }
}

