/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtil;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureSkipPersistence {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureSkipPersistence.class);
    private ProcedureExecutor<ProcEnv> procExecutor;
    private ProcedureStore procStore;
    private HBaseCommonTestingUtil htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;
    private static volatile int STEP = 0;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtil();
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(this.testDir, "proc-logs");
        this.procStore = ProcedureTestingUtility.createWalStore(this.htu.getConfiguration(), this.logDir);
        this.procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)new ProcEnv(), this.procStore);
        this.procStore.start(1);
        ProcedureTestingUtility.initAndStartWorkers(this.procExecutor, 1, true);
    }

    @After
    public void tearDown() throws IOException {
        this.procExecutor.stop();
        this.procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    @Test
    public void test() throws Exception {
        TestProcedure proc = new TestProcedure();
        long procId = this.procExecutor.submitProcedure((Procedure)proc);
        this.htu.waitFor(30000L, () -> proc.isWaiting() && this.procExecutor.getActiveExecutorCount() == 0);
        ProcedureTestingUtility.restart(this.procExecutor);
        this.htu.waitFor(30000L, () -> {
            Procedure p = this.procExecutor.getProcedure(procId);
            return (p.isWaiting() || p.isFinished()) && this.procExecutor.getActiveExecutorCount() == 0;
        });
        Assert.assertFalse((boolean)this.procExecutor.isFinished(procId));
        ProcedureTestingUtility.restart(this.procExecutor);
        this.htu.waitFor(30000L, () -> this.procExecutor.isFinished(procId));
        Procedure p = this.procExecutor.getResult(procId);
        Assert.assertTrue((boolean)p.isSuccess());
    }

    public static class TestProcedure
    extends Procedure<ProcEnv> {
        protected boolean holdLock(ProcEnv env) {
            return true;
        }

        protected Procedure<ProcEnv>[] execute(ProcEnv env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
            if (STEP == 0) {
                STEP = 1;
                this.setTimeout(3600000);
                this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
                this.skipPersistence();
                throw new ProcedureSuspendedException();
            }
            if (STEP == 1) {
                STEP = 2;
                if (this.hasTimeout()) {
                    this.setFailure("Should not persist the timeout value", new IOException("Should not persist the timeout value"));
                    return null;
                }
                this.setTimeout(2000);
                this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
                throw new ProcedureSuspendedException();
            }
            if (!this.hasTimeout()) {
                this.setFailure("Should have persisted the timeout value", new IOException("Should have persisted the timeout value"));
            }
            return null;
        }

        protected synchronized boolean setTimeoutFailure(ProcEnv env) {
            this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
            env.getProcedureExecutor().getProcedureScheduler().addFront((Procedure)this);
            return false;
        }

        protected void rollback(ProcEnv env) throws IOException, InterruptedException {
            throw new UnsupportedOperationException();
        }

        protected boolean abort(ProcEnv env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }
    }

    public class ProcEnv {
        public ProcedureExecutor<ProcEnv> getProcedureExecutor() {
            return TestProcedureSkipPersistence.this.procExecutor;
        }
    }
}

