/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.blockmeta;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestBlockMeta {
    static int BLOCK_START = 123;

    private static PrefixTreeBlockMeta createSample() {
        PrefixTreeBlockMeta m = new PrefixTreeBlockMeta();
        m.setNumMetaBytes(0);
        m.setNumKeyValueBytes(3195);
        m.setNumRowBytes(0);
        m.setNumFamilyBytes(3);
        m.setNumQualifierBytes(12345);
        m.setNumTagsBytes(50);
        m.setNumTimestampBytes(23456);
        m.setNumMvccVersionBytes(5);
        m.setNumValueBytes(34567);
        m.setNextNodeOffsetWidth(3);
        m.setFamilyOffsetWidth(1);
        m.setQualifierOffsetWidth(2);
        m.setTagsOffsetWidth(2);
        m.setTimestampIndexWidth(1);
        m.setMvccVersionIndexWidth(2);
        m.setValueOffsetWidth(8);
        m.setValueLengthWidth(3);
        m.setRowTreeDepth(11);
        m.setMaxRowLength(200);
        m.setMaxQualifierLength(50);
        m.setMaxTagsLength(40);
        m.setMinTimestamp(1318966363481L);
        m.setTimestampDeltaWidth(3);
        m.setMinMvccVersion(100L);
        m.setMvccVersionDeltaWidth(4);
        m.setAllSameType(false);
        m.setAllTypes(KeyValue.Type.Delete.getCode());
        m.setNumUniqueRows(88);
        m.setNumUniqueFamilies(1);
        m.setNumUniqueQualifiers(56);
        m.setNumUniqueTags(5);
        return m;
    }

    @Test
    public void testStreamSerialization() throws IOException {
        PrefixTreeBlockMeta original = TestBlockMeta.createSample();
        ByteArrayOutputStream os = new ByteArrayOutputStream(10000);
        original.writeVariableBytesToOutputStream((OutputStream)os);
        ByteBuffer buffer = ByteBuffer.wrap(os.toByteArray());
        PrefixTreeBlockMeta roundTripped = new PrefixTreeBlockMeta(buffer);
        Assert.assertTrue((boolean)original.equals((Object)roundTripped));
    }
}

