/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.vint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.number.RandomNumberUtils;
import org.apache.hadoop.hbase.util.vint.UVLongTool;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestVLongTool {
    @Test
    public void testNumBytes() {
        Assert.assertEquals((long)1L, (long)UVLongTool.numBytes((long)0L));
        Assert.assertEquals((long)1L, (long)UVLongTool.numBytes((long)1L));
        Assert.assertEquals((long)1L, (long)UVLongTool.numBytes((long)100L));
        Assert.assertEquals((long)1L, (long)UVLongTool.numBytes((long)126L));
        Assert.assertEquals((long)1L, (long)UVLongTool.numBytes((long)127L));
        Assert.assertEquals((long)2L, (long)UVLongTool.numBytes((long)128L));
        Assert.assertEquals((long)2L, (long)UVLongTool.numBytes((long)129L));
        Assert.assertEquals((long)9L, (long)UVLongTool.numBytes((long)Long.MAX_VALUE));
    }

    @Test
    public void testToBytes() {
        Assert.assertArrayEquals((byte[])new byte[]{0}, (byte[])UVLongTool.getBytes((long)0L));
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])UVLongTool.getBytes((long)1L));
        Assert.assertArrayEquals((byte[])new byte[]{63}, (byte[])UVLongTool.getBytes((long)63L));
        Assert.assertArrayEquals((byte[])new byte[]{127}, (byte[])UVLongTool.getBytes((long)127L));
        Assert.assertArrayEquals((byte[])new byte[]{-128, 1}, (byte[])UVLongTool.getBytes((long)128L));
        Assert.assertArrayEquals((byte[])new byte[]{-101, 1}, (byte[])UVLongTool.getBytes((long)155L));
        Assert.assertArrayEquals((byte[])UVLongTool.MAX_VALUE_BYTES, (byte[])UVLongTool.getBytes((long)Long.MAX_VALUE));
    }

    @Test
    public void testFromBytes() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)UVLongTool.getLong((byte[])UVLongTool.MAX_VALUE_BYTES));
    }

    @Test
    public void testFromBytesOffset() {
        Assert.assertEquals((long)Long.MAX_VALUE, (long)UVLongTool.getLong((byte[])UVLongTool.MAX_VALUE_BYTES, (int)0));
        long ms = 1318966363481L;
        byte[] bytes = UVLongTool.getBytes((long)ms);
        long roundTripped = UVLongTool.getLong((byte[])bytes, (int)0);
        Assert.assertEquals((long)ms, (long)roundTripped);
        int calculatedNumBytes = UVLongTool.numBytes((long)ms);
        int actualNumBytes = bytes.length;
        Assert.assertEquals((long)actualNumBytes, (long)calculatedNumBytes);
        byte[] shiftedBytes = new byte[1000];
        int shift = 33;
        System.arraycopy(bytes, 0, shiftedBytes, shift, bytes.length);
        long shiftedRoundTrip = UVLongTool.getLong((byte[])shiftedBytes, (int)shift);
        Assert.assertEquals((long)ms, (long)shiftedRoundTrip);
    }

    @Test
    public void testRoundTrips() {
        Random random = new Random();
        for (int i = 0; i < 10000; ++i) {
            long value = RandomNumberUtils.nextPositiveLong(random);
            byte[] bytes = UVLongTool.getBytes((long)value);
            long roundTripped = UVLongTool.getLong((byte[])bytes);
            Assert.assertEquals((long)value, (long)roundTripped);
            int calculatedNumBytes = UVLongTool.numBytes((long)value);
            int actualNumBytes = bytes.length;
            Assert.assertEquals((long)actualNumBytes, (long)calculatedNumBytes);
        }
    }

    @Test
    public void testInputStreams() throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(new byte[]{0});
        Assert.assertEquals((long)0L, (long)UVLongTool.getLong((InputStream)is));
        is = new ByteArrayInputStream(new byte[]{5});
        Assert.assertEquals((long)5L, (long)UVLongTool.getLong((InputStream)is));
        is = new ByteArrayInputStream(new byte[]{-101, 1});
        Assert.assertEquals((long)155L, (long)UVLongTool.getLong((InputStream)is));
    }
}

