/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.row.data;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.row.BaseTestRowData;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellScannerPosition;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellSearcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class TestRowDataTrivialWithTags
extends BaseTestRowData {
    static byte[] rA = Bytes.toBytes((String)"rA");
    static byte[] rB = Bytes.toBytes((String)"rB");
    static byte[] cf = Bytes.toBytes((String)"fam");
    static byte[] cq0 = Bytes.toBytes((String)"q0");
    static byte[] v0 = Bytes.toBytes((String)"v0");
    static long ts = 55L;
    static List<KeyValue> d = Lists.newArrayList();

    @Override
    public List<KeyValue> getInputs() {
        return d;
    }

    @Override
    public void individualBlockMetaAssertions(PrefixTreeBlockMeta blockMeta) {
        Assert.assertEquals((long)2L, (long)blockMeta.getRowTreeDepth());
    }

    @Override
    public void individualSearcherAssertions(CellSearcher searcher) {
        KeyValue afterLast = KeyValue.createFirstOnRow((byte[])Bytes.toBytes((String)"zzz"));
        CellScannerPosition position = searcher.positionAtOrAfter((Cell)afterLast);
        Assert.assertEquals((Object)CellScannerPosition.AFTER_LAST, (Object)position);
        Assert.assertNull((Object)searcher.current());
    }

    static {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        Tag t = new Tag(1, "visisbility");
        tagList.add(t);
        t = new Tag(2, "ACL");
        tagList.add(t);
        d.add(new KeyValue(rA, cf, cq0, ts, v0, tagList));
        d.add(new KeyValue(rB, cf, cq0, ts, v0, tagList));
    }
}

