/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.row;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataComplexQualifiers;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataDeeper;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataDifferentTimestamps;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataEmpty;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataExerciseFInts;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataNub;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataNumberStrings;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataQualifierByteOrdering;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataRandomKeyValues;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataRandomKeyValuesWithTags;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataSearcherRowMiss;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataSimple;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataSingleQualifier;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataTrivial;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataTrivialWithTags;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataUrls;
import org.apache.hadoop.hbase.codec.prefixtree.row.data.TestRowDataUrlsExample;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellSearcher;

public interface TestRowData {
    public List<KeyValue> getInputs();

    public List<Integer> getRowStartIndexes();

    public void individualBlockMetaAssertions(PrefixTreeBlockMeta var1);

    public void individualSearcherAssertions(CellSearcher var1);

    public static class InMemory {
        public static Collection<TestRowData> getAll() {
            ArrayList all = Lists.newArrayList();
            all.add(new TestRowDataEmpty());
            all.add(new TestRowDataTrivial());
            all.add(new TestRowDataTrivialWithTags());
            all.add(new TestRowDataSimple());
            all.add(new TestRowDataDeeper());
            all.add(new TestRowDataSingleQualifier());
            all.add(new TestRowDataNub());
            all.add(new TestRowDataSearcherRowMiss());
            all.add(new TestRowDataQualifierByteOrdering());
            all.add(new TestRowDataComplexQualifiers());
            all.add(new TestRowDataDifferentTimestamps());
            all.add(new TestRowDataNumberStrings());
            all.add(new TestRowDataUrls());
            all.add(new TestRowDataUrlsExample());
            all.add(new TestRowDataExerciseFInts());
            all.add(new TestRowDataRandomKeyValues());
            all.add(new TestRowDataRandomKeyValuesWithTags());
            return all;
        }

        public static Collection<Object[]> getAllAsObjectArray() {
            ArrayList all = Lists.newArrayList();
            for (TestRowData testRows : InMemory.getAll()) {
                all.add(new Object[]{testRows});
            }
            return all;
        }
    }
}

