/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.row.data;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.row.BaseTestRowData;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class TestRowDataDifferentTimestamps
extends BaseTestRowData {
    static byte[] Arow = Bytes.toBytes((String)"Arow");
    static byte[] Brow = Bytes.toBytes((String)"Brow");
    static byte[] cf = Bytes.toBytes((String)"fammy");
    static byte[] cq0 = Bytes.toBytes((String)"cq0");
    static byte[] cq1 = Bytes.toBytes((String)"cq1");
    static byte[] v0 = Bytes.toBytes((String)"v0");
    static List<KeyValue> d = Lists.newArrayList();

    @Override
    public List<KeyValue> getInputs() {
        return d;
    }

    @Override
    public void individualBlockMetaAssertions(PrefixTreeBlockMeta blockMeta) {
        Assert.assertTrue((blockMeta.getNumMvccVersionBytes() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)12L, (long)blockMeta.getNumValueBytes());
        Assert.assertFalse((boolean)blockMeta.isAllSameTimestamp());
        Assert.assertNotNull((Object)blockMeta.getMinTimestamp());
        Assert.assertTrue((blockMeta.getTimestampIndexWidth() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((blockMeta.getTimestampDeltaWidth() > 0 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)blockMeta.isAllSameMvccVersion());
        Assert.assertNotNull((Object)blockMeta.getMinMvccVersion());
        Assert.assertTrue((blockMeta.getMvccVersionIndexWidth() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((blockMeta.getMvccVersionDeltaWidth() > 0 ? 1 : 0) != 0);
    }

    static {
        KeyValue kv0 = new KeyValue(Arow, cf, cq0, 0L, v0);
        kv0.setMvccVersion(123456789L);
        d.add(kv0);
        KeyValue kv1 = new KeyValue(Arow, cf, cq1, 1L, v0);
        kv1.setMvccVersion(3L);
        d.add(kv1);
        KeyValue kv2 = new KeyValue(Brow, cf, cq0, 12345678L, v0);
        kv2.setMvccVersion(65537L);
        d.add(kv2);
        KeyValue kv3 = new KeyValue(Brow, cf, cq1, 0x7FFFFFFFFFFFFFFEL, v0);
        kv3.setMvccVersion(1L);
        d.add(kv3);
        KeyValue kv4 = new KeyValue(Brow, cf, cq1, 999999999L, v0);
        d.add(kv4);
        KeyValue kv5 = new KeyValue(Brow, cf, cq1, 12345L, v0);
        kv5.setMvccVersion(0L);
        d.add(kv5);
    }
}

