/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.net.URI;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.TestExportSnapshot;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowMapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
@Category(value={VerySlowMapReduceTests.class, LargeTests.class})
public class TestExportSnapshotAdjunct {
    private static final Logger LOG = LoggerFactory.getLogger(TestExportSnapshotAdjunct.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExportSnapshotAdjunct.class);
    @Rule
    public final TestName testName = new TestName();
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    protected TableName tableName;
    private String emptySnapshotName;
    private String snapshotName;
    private int tableNumFiles;
    private Admin admin;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestExportSnapshot.setUpBaseConf(TEST_UTIL.getConfiguration());
        TEST_UTIL.startMiniCluster(3);
        TEST_UTIL.startMiniMapReduceCluster();
    }

    private void checkForReferencesToTmpDir() {
        Configuration conf = TEST_UTIL.getConfiguration();
        for (Map.Entry e : conf) {
            if (((String)e.getKey()).contains("original.hbase.dir") || ((String)e.getValue()).contains("java.io.tmpdir") || ((String)e.getValue()).contains("hadoop.tmp.dir") || ((String)e.getValue()).contains("hbase.tmp.dir")) continue;
            Assert.assertFalse((String)((String)e.getKey() + " " + (String)e.getValue()), (boolean)((String)e.getValue()).contains("tmp"));
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniMapReduceCluster();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        this.admin = TEST_UTIL.getAdmin();
        this.tableName = TableName.valueOf((String)("testtb-" + this.testName.getMethodName()));
        this.snapshotName = "snaptb0-" + this.testName.getMethodName();
        this.emptySnapshotName = "emptySnaptb0-" + this.testName.getMethodName();
        SnapshotTestingUtils.createPreSplitTable((HBaseTestingUtility)TEST_UTIL, (TableName)this.tableName, (int)2, (byte[][])new byte[][]{TestExportSnapshot.FAMILY});
        this.admin.snapshot(this.emptySnapshotName, this.tableName);
        SnapshotTestingUtils.loadData((HBaseTestingUtility)TEST_UTIL, (TableName)this.tableName, (int)50, (byte[][])new byte[][]{TestExportSnapshot.FAMILY});
        this.tableNumFiles = this.admin.getRegions(this.tableName).size();
        this.admin.snapshot(this.snapshotName, this.tableName);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.deleteTable(this.tableName);
        SnapshotTestingUtils.deleteAllSnapshots((Admin)TEST_UTIL.getAdmin());
        SnapshotTestingUtils.deleteArchiveDirectory((HBaseTestingUtility)TEST_UTIL);
    }

    @Test
    public void testExportRetry() throws Exception {
        Path copyDir = TestExportSnapshot.getLocalDestinationDir(TEST_UTIL);
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setBoolean("test.snapshot.export.failure", true);
        conf.setInt("test.snapshot.export.failure.count", 2);
        conf.setInt("mapreduce.map.maxattempts", 3);
        TestExportSnapshot.testExportFileSystemState(conf, this.tableName, Bytes.toBytes((String)this.snapshotName), Bytes.toBytes((String)this.snapshotName), this.tableNumFiles, TEST_UTIL.getDefaultRootDirPath(), copyDir, true, false, null, true);
    }

    @Test
    public void testExportFailure() throws Exception {
        Path copyDir = TestExportSnapshot.getLocalDestinationDir(TEST_UTIL);
        FileSystem fs = FileSystem.get((URI)copyDir.toUri(), (Configuration)new Configuration());
        copyDir = copyDir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setBoolean("test.snapshot.export.failure", true);
        conf.setInt("test.snapshot.export.failure.count", 4);
        conf.setInt("mapreduce.map.maxattempts", 3);
        TestExportSnapshot.testExportFileSystemState(conf, this.tableName, Bytes.toBytes((String)this.snapshotName), Bytes.toBytes((String)this.snapshotName), this.tableNumFiles, TEST_UTIL.getDefaultRootDirPath(), copyDir, true, false, null, false);
    }
}

