/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.TestExportSnapshot;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MapReduceTests.class, MediumTests.class})
public class TestExportSnapshotV1NoCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExportSnapshotV1NoCluster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestExportSnapshotV1NoCluster.class);
    private HBaseCommonTestingUtility testUtil = new HBaseCommonTestingUtility();
    private Path testDir;
    private FileSystem fs;

    @Before
    public void setUpBefore() throws Exception {
        this.fs = FileSystem.getLocal((Configuration)this.testUtil.getConfiguration());
        this.testDir = TestExportSnapshotV1NoCluster.setup(this.fs, this.testUtil);
        LOG.info("fs={}, fsuri={}, fswd={}, testDir={}", new Object[]{this.fs, this.fs.getUri(), this.fs.getWorkingDirectory(), this.testDir});
        Assert.assertTrue((String)("FileSystem '" + this.fs + "' is not local"), (boolean)(this.fs instanceof LocalFileSystem));
    }

    static Path setup(FileSystem fs, HBaseCommonTestingUtility hctu) throws IOException {
        Path testDir = hctu.getDataTestDir().makeQualified(fs.getUri(), fs.getWorkingDirectory());
        hctu.getConfiguration().setBoolean("hbase.snapshot.enabled", true);
        hctu.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        hctu.getConfiguration().setInt("hbase.client.pause", 250);
        hctu.getConfiguration().setInt("hbase.client.retries.number", 6);
        hctu.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        hctu.getConfiguration().setInt("mapreduce.map.maxattempts", 10);
        hctu.getConfiguration().set("hbase.rootdir", testDir.toString());
        return testDir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    @Test
    public void testSnapshotWithRefsExportFileSystemState() throws Exception {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(this.testUtil.getConfiguration(), this.fs, this.testDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV1("tableWithRefsV1", "tableWithRefsV1");
        TestExportSnapshotV1NoCluster.testSnapshotWithRefsExportFileSystemState(this.fs, builder, this.testUtil, this.testDir);
    }

    static void testSnapshotWithRefsExportFileSystemState(FileSystem fs, SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder, HBaseCommonTestingUtility testUtil, Path testDir) throws Exception {
        Path[] r1Files = builder.addRegion();
        Path[] r2Files = builder.addRegion();
        builder.commit();
        int snapshotFilesCount = r1Files.length + r2Files.length;
        byte[] snapshotName = Bytes.toBytes((String)builder.getSnapshotDescription().getName());
        TableName tableName = builder.getTableDescriptor().getTableName();
        TestExportSnapshot.testExportFileSystemState(testUtil.getConfiguration(), tableName, snapshotName, snapshotName, snapshotFilesCount, testDir, TestExportSnapshotV1NoCluster.getDestinationDir(fs, testUtil, testDir), false, null, true);
    }

    static Path getDestinationDir(FileSystem fs, HBaseCommonTestingUtility hctu, Path testDir) throws IOException {
        Path path = new Path(new Path(testDir, "export-test"), "export-" + System.currentTimeMillis()).makeQualified(fs.getUri(), fs.getWorkingDirectory());
        LOG.info("Export destination={}, fs={}, fsurl={}, fswd={}, testDir={}", new Object[]{path, fs, fs.getUri(), fs.getWorkingDirectory(), testDir});
        return path;
    }
}

