/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.snapshot.TestExportSnapshot;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
@Category(value={MapReduceTests.class, MediumTests.class})
public class TestExportSnapshotNoCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestExportSnapshotNoCluster.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestExportSnapshotNoCluster.class);
    private final HBaseCommonTestingUtility testUtil = new HBaseCommonTestingUtility();
    private FileSystem fs;
    private Path testDir;

    public void setUpBaseConf(Configuration conf) {
        conf.setBoolean("hbase.snapshot.enabled", true);
        conf.setInt("hbase.regionserver.msginterval", 100);
        conf.setInt("hbase.client.pause", 250);
        conf.setInt("hbase.client.retries.number", 6);
        conf.setBoolean("hbase.master.enabletable.roundrobin", true);
        conf.setInt("mapreduce.map.maxattempts", 10);
        conf.set("hbase.rootdir", this.testDir.toString());
    }

    @Before
    public void setUpBefore() throws Exception {
        this.testDir = this.testUtil.getDataTestDir().makeQualified(URI.create("file:///"), new Path("/"));
        this.fs = this.testDir.getFileSystem(this.testUtil.getConfiguration());
        Assert.assertTrue((String)("FileSystem '" + this.fs + "' is not local"), (boolean)(this.fs instanceof LocalFileSystem));
        this.setUpBaseConf(this.testUtil.getConfiguration());
    }

    @Test
    public void testSnapshotV1WithRefsExportFileSystemState() throws Exception {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(this.testUtil.getConfiguration(), this.fs, this.testDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV1("tableWithRefsV1", "tableWithRefsV1");
        this.testSnapshotWithRefsExportFileSystemState(builder);
    }

    @Test
    public void testSnapshotV2WithRefsExportFileSystemState() throws Exception {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(this.testUtil.getConfiguration(), this.fs, this.testDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2("tableWithRefsV2", "tableWithRefsV2");
        this.testSnapshotWithRefsExportFileSystemState(builder);
    }

    private void testSnapshotWithRefsExportFileSystemState(SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder) throws Exception {
        Path[] r1Files = builder.addRegion();
        Path[] r2Files = builder.addRegion();
        builder.commit();
        int snapshotFilesCount = r1Files.length + r2Files.length;
        byte[] snapshotName = Bytes.toBytes((String)builder.getSnapshotDescription().getName());
        TableName tableName = builder.getTableDescriptor().getTableName();
        TestExportSnapshot.testExportFileSystemState(this.testUtil.getConfiguration(), tableName, snapshotName, snapshotName, snapshotFilesCount, this.testDir, this.getDestinationDir(), false, null, true);
    }

    private Path getDestinationDir() {
        Path path = new Path(new Path(this.testDir, "export-test"), "export-" + System.currentTimeMillis());
        LOG.info("HDFS export destination path: " + path);
        return path;
    }
}

