/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hadoop.hbase.replication.TestReplicationBase;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestVerifyReplication
extends TestReplicationBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVerifyReplication.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestVerifyReplication.class);
    private static final String PEER_ID = "2";
    private static final TableName peerTableName = TableName.valueOf((String)"peerTest");
    private static Table htable3;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        this.cleanUp();
        UTIL2.deleteTableData(peerTableName);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TestReplicationBase.setUpBeforeClass();
        TableDescriptor peerTable = TableDescriptorBuilder.newBuilder((TableName)peerTableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])noRepfamName).setMaxVersions(100).build()).build();
        Connection connection2 = ConnectionFactory.createConnection((Configuration)CONF2);
        try (Admin admin2 = connection2.getAdmin();){
            admin2.createTable(peerTable, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
        }
        htable3 = connection2.getTable(peerTableName);
    }

    private void runVerifyReplication(String[] args, int expectedGoodRows, int expectedBadRows) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = new VerifyReplication().createSubmittableJob(new Configuration(CONF1), args);
        if (job == null) {
            Assert.fail((String)"Job wasn't created, see the log");
        }
        if (!job.waitForCompletion(true)) {
            Assert.fail((String)"Job failed, see the log");
        }
        Assert.assertEquals((long)expectedGoodRows, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)expectedBadRows, (long)job.getCounters().findCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
    }

    @Test
    public void testVerifyRepJob() throws Exception {
        TestVerifyReplication.runSmallBatchTest();
        String[] args = new String[]{PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 100, 0);
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            put.addColumn(CellUtil.cloneFamily((Cell)firstVal), CellUtil.cloneQualifier((Cell)firstVal), Bytes.toBytes((String)"diff data"));
            htable2.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        this.runVerifyReplication(args, 0, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVerifyRepJobWithRawOptions() throws Exception {
        LOG.info(this.name.getMethodName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] familyname = Bytes.toBytes((String)"fam_raw");
        byte[] row = Bytes.toBytes((String)"row_raw");
        Table lHtable1 = null;
        Table lHtable2 = null;
        try {
            ColumnFamilyDescriptor fam = ColumnFamilyDescriptorBuilder.newBuilder((byte[])familyname).setMaxVersions(100).setScope(1).build();
            TableDescriptor table = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(fam).build();
            Connection connection1 = ConnectionFactory.createConnection((Configuration)CONF1);
            Connection connection2 = ConnectionFactory.createConnection((Configuration)CONF2);
            try (Admin admin1 = connection1.getAdmin();){
                admin1.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            var11_11 = null;
            try (Admin admin2 = connection2.getAdmin();){
                admin2.createTable(table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            catch (Throwable throwable) {
                var11_11 = throwable;
                throw throwable;
            }
            UTIL1.waitUntilAllRegionsAssigned(tableName);
            UTIL2.waitUntilAllRegionsAssigned(tableName);
            lHtable1 = UTIL1.getConnection().getTable(tableName);
            lHtable2 = UTIL2.getConnection().getTable(tableName);
            Put put = new Put(row);
            put.addColumn(familyname, row, row);
            lHtable1.put(put);
            Get get = new Get(row);
            for (int i = 0; i < 50; ++i) {
                Result res;
                if (i == 49) {
                    Assert.fail((String)"Waited too much time for put replication");
                }
                if (!(res = lHtable2.get(get)).isEmpty()) {
                    Assert.assertArrayEquals((byte[])res.value(), (byte[])row);
                    break;
                }
                LOG.info("Row not available");
                Thread.sleep(500L);
            }
            Delete del = new Delete(row);
            lHtable1.delete(del);
            get = new Get(row);
            for (int i = 0; i < 50; ++i) {
                Result res;
                if (i == 49) {
                    Assert.fail((String)"Waited too much time for del replication");
                }
                if ((res = lHtable2.get(get)).size() < 1) break;
                LOG.info("Row not deleted");
                Thread.sleep(500L);
            }
            String[] argsWithoutRaw = new String[]{PEER_ID, tableName.getNameAsString()};
            this.runVerifyReplication(argsWithoutRaw, 0, 0);
            String[] argsWithRawAsTrue = new String[]{"--raw", PEER_ID, tableName.getNameAsString()};
            this.runVerifyReplication(argsWithRawAsTrue, 1, 0);
        }
        finally {
            if (lHtable1 != null) {
                lHtable1.close();
            }
            if (lHtable2 != null) {
                lHtable2.close();
            }
        }
    }

    @Test
    public void testHBase14905() throws Exception {
        byte[] qualifierName = Bytes.toBytes((String)"f1");
        Put put = new Put(Bytes.toBytes((String)"r1"));
        long ts = System.currentTimeMillis();
        put.addColumn(famName, qualifierName, ts + 1L, Bytes.toBytes((String)"v1002"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v1001"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 3L, Bytes.toBytes((String)"v1112"));
        htable1.put(put);
        Scan scan = new Scan();
        scan.readVersions(100);
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(1);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        for (int i = 0; i < 50; ++i) {
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(1);
            scanner1.close();
            if (res1.length != 1) {
                LOG.info("Only got " + res1.length + " rows");
                Thread.sleep(500L);
            } else {
                int cellNumber = res1[0].getColumnCells(famName, Bytes.toBytes((String)"f1")).size();
                if (cellNumber == 3) break;
                LOG.info("Only got " + cellNumber + " cells");
                Thread.sleep(500L);
            }
            if (i != 49) continue;
            Assert.fail((String)"Waited too much time for normal batch replication");
        }
        put.addColumn(famName, qualifierName, ts + 4L, Bytes.toBytes((String)"v1111"));
        htable2.put(put);
        put.addColumn(famName, qualifierName, ts + 5L, Bytes.toBytes((String)"v1112"));
        htable2.put(put);
        scan = new Scan();
        scan.readVersions(100);
        scanner1 = htable2.getScanner(scan);
        res1 = scanner1.next(100);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)5L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        String[] args = new String[]{"--versions=100", PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVersionMismatchHBase14905() throws Exception {
        byte[] qualifierName = Bytes.toBytes((String)"f1");
        Put put = new Put(Bytes.toBytes((String)"r1"));
        long ts = System.currentTimeMillis();
        put.addColumn(famName, qualifierName, ts + 1L, Bytes.toBytes((String)"v1"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v2"));
        htable1.put(put);
        put.addColumn(famName, qualifierName, ts + 3L, Bytes.toBytes((String)"v3"));
        htable1.put(put);
        Scan scan = new Scan();
        scan.readVersions(100);
        ResultScanner scanner1 = htable1.getScanner(scan);
        Result[] res1 = scanner1.next(1);
        scanner1.close();
        Assert.assertEquals((long)1L, (long)res1.length);
        Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
        for (int i = 0; i < 50; ++i) {
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(1);
            scanner1.close();
            if (res1.length != 1) {
                LOG.info("Only got " + res1.length + " rows");
                Thread.sleep(500L);
            } else {
                int cellNumber = res1[0].getColumnCells(famName, Bytes.toBytes((String)"f1")).size();
                if (cellNumber == 3) break;
                LOG.info("Only got " + cellNumber + " cells");
                Thread.sleep(500L);
            }
            if (i != 49) continue;
            Assert.fail((String)"Waited too much time for normal batch replication");
        }
        try {
            hbaseAdmin.disableReplicationPeer(PEER_ID);
            Put put2 = new Put(Bytes.toBytes((String)"r1"));
            put2.addColumn(famName, qualifierName, ts + 2L, Bytes.toBytes((String)"v99"));
            htable2.put(put2);
            scan = new Scan();
            scan.readVersions(100);
            scanner1 = htable2.getScanner(scan);
            res1 = scanner1.next(100);
            scanner1.close();
            Assert.assertEquals((long)1L, (long)res1.length);
            Assert.assertEquals((long)3L, (long)res1[0].getColumnCells(famName, qualifierName).size());
            String[] args = new String[]{"--versions=100", PEER_ID, tableName.getNameAsString()};
            this.runVerifyReplication(args, 0, 1);
        }
        finally {
            hbaseAdmin.enableReplicationPeer(PEER_ID);
        }
    }

    @Test
    public void testVerifyReplicationPrefixFiltering() throws Exception {
        byte[] prefixRow = Bytes.toBytes((String)"prefixrow");
        byte[] prefixRow2 = Bytes.toBytes((String)"secondrow");
        TestVerifyReplication.loadData((String)"prefixrow", (byte[])prefixRow);
        TestVerifyReplication.loadData((String)"secondrow", (byte[])prefixRow2);
        TestVerifyReplication.loadData((String)"aaa", (byte[])row);
        TestVerifyReplication.loadData((String)"zzz", (byte[])row);
        TestVerifyReplication.waitForReplication((int)400, (int)200);
        String[] args = new String[]{"--row-prefixes=prefixrow,secondrow", PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 200, 0);
    }

    @Test
    public void testVerifyReplicationSnapshotArguments() {
        Object[] args = new String[]{"--sourceSnapshotName=snapshot1", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotTmpDir=tmp", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotName=snapshot1", "--sourceSnapshotTmpDir=tmp", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotName=snapshot1", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotTmpDir=/tmp/", PEER_ID, tableName.getNameAsString()};
        Assert.assertFalse((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--peerSnapshotName=snapshot1", "--peerSnapshotTmpDir=/tmp/", "--peerFSAddress=tempfs", "--peerHBaseRootAddress=hdfs://tempfs:50070/hbase/", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
        args = new String[]{"--sourceSnapshotName=snapshot1", "--sourceSnapshotTmpDir=/tmp/", "--peerSnapshotName=snapshot2", "--peerSnapshotTmpDir=/tmp/", "--peerFSAddress=tempfs", "--peerHBaseRootAddress=hdfs://tempfs:50070/hbase/", PEER_ID, tableName.getNameAsString()};
        Assert.assertTrue((String)Lists.newArrayList((Object[])args).toString(), (boolean)new VerifyReplication().doCommandLine((String[])args));
    }

    private void checkRestoreTmpDir(Configuration conf, String restoreTmpDir, int expectedCount) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        FileStatus[] subDirectories = fs.listStatus(new Path(restoreTmpDir));
        Assert.assertNotNull((Object)subDirectories);
        Assert.assertEquals((long)subDirectories.length, (long)expectedCount);
        for (int i = 0; i < expectedCount; ++i) {
            Assert.assertTrue((boolean)subDirectories[i].isDirectory());
        }
    }

    @Test
    public void testVerifyReplicationWithSnapshotSupport() throws Exception {
        TestVerifyReplication.runSmallBatchTest();
        Path rootDir = FSUtils.getRootDir((Configuration)CONF1);
        FileSystem fs = rootDir.getFileSystem(CONF1);
        String sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL1.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        Path peerRootDir = FSUtils.getRootDir((Configuration)CONF2);
        FileSystem peerFs = peerRootDir.getFileSystem(CONF2);
        String peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL2.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        String peerFSAddress = peerFs.getUri().toString();
        String temPath1 = UTIL1.getRandomDir().toString();
        String temPath2 = "/tmp" + System.currentTimeMillis();
        String[] args = new String[]{"--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + temPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + temPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + FSUtils.getRootDir((Configuration)CONF2), PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 100, 0);
        this.checkRestoreTmpDir(CONF1, temPath1, 1);
        this.checkRestoreTmpDir(CONF2, temPath2, 1);
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            put.addColumn(CellUtil.cloneFamily((Cell)firstVal), CellUtil.cloneQualifier((Cell)firstVal), Bytes.toBytes((String)"diff data"));
            htable2.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL1.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL2.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        args = new String[]{"--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + temPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + temPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + FSUtils.getRootDir((Configuration)CONF2), PEER_ID, tableName.getNameAsString()};
        this.runVerifyReplication(args, 0, 100);
        this.checkRestoreTmpDir(CONF1, temPath1, 2);
        this.checkRestoreTmpDir(CONF2, temPath2, 2);
    }

    @Test
    public void testVerifyRepJobWithQuorumAddress() throws Exception {
        TestVerifyReplication.runSmallBatchTest();
        String[] args = new String[]{UTIL2.getClusterKey(), tableName.getNameAsString()};
        this.runVerifyReplication(args, 100, 0);
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            put.addColumn(CellUtil.cloneFamily((Cell)firstVal), CellUtil.cloneQualifier((Cell)firstVal), Bytes.toBytes((String)"diff data"));
            htable2.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        this.runVerifyReplication(args, 0, 100);
    }

    @Test
    public void testVerifyRepJobWithQuorumAddressAndSnapshotSupport() throws Exception {
        TestVerifyReplication.runSmallBatchTest();
        Path rootDir = FSUtils.getRootDir((Configuration)CONF1);
        FileSystem fs = rootDir.getFileSystem(CONF1);
        String sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL1.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        Path peerRootDir = FSUtils.getRootDir((Configuration)CONF2);
        FileSystem peerFs = peerRootDir.getFileSystem(CONF2);
        String peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL2.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        String peerFSAddress = peerFs.getUri().toString();
        String tmpPath1 = UTIL1.getRandomDir().toString();
        String tmpPath2 = "/tmp" + System.currentTimeMillis();
        String[] args = new String[]{"--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + tmpPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + tmpPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + FSUtils.getRootDir((Configuration)CONF2), UTIL2.getClusterKey(), tableName.getNameAsString()};
        this.runVerifyReplication(args, 100, 0);
        this.checkRestoreTmpDir(CONF1, tmpPath1, 1);
        this.checkRestoreTmpDir(CONF2, tmpPath2, 1);
        Scan scan = new Scan();
        ResultScanner rs = htable2.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            put.addColumn(CellUtil.cloneFamily((Cell)firstVal), CellUtil.cloneQualifier((Cell)firstVal), Bytes.toBytes((String)"diff data"));
            htable2.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable2.delete(delete);
        sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL1.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL2.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])famName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        args = new String[]{"--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + tmpPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + tmpPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + FSUtils.getRootDir((Configuration)CONF2), UTIL2.getClusterKey(), tableName.getNameAsString()};
        this.runVerifyReplication(args, 0, 100);
        this.checkRestoreTmpDir(CONF1, tmpPath1, 2);
        this.checkRestoreTmpDir(CONF2, tmpPath2, 2);
    }

    private static void runBatchCopyTest() throws Exception {
        Result[] res1;
        TestVerifyReplication.loadData((String)"", (byte[])row, (byte[])noRepfamName);
        Scan scan1 = new Scan();
        ArrayList<Put> puts = new ArrayList<Put>(100);
        ResultScanner scanner1 = htable1.getScanner(scan1);
        for (Result result : res1 = scanner1.next(100)) {
            Put put = new Put(result.getRow());
            for (Cell cell : result.rawCells()) {
                put.add(cell);
            }
            puts.add(put);
        }
        scanner1.close();
        Assert.assertEquals((long)100L, (long)res1.length);
        htable3.put(puts);
        Scan scan2 = new Scan();
        ResultScanner scanner2 = htable3.getScanner(scan2);
        Result[] res2 = scanner2.next(100);
        scanner2.close();
        Assert.assertEquals((long)100L, (long)res2.length);
    }

    @Test
    public void testVerifyRepJobWithPeerTableName() throws Exception {
        TestVerifyReplication.runBatchCopyTest();
        String[] args = new String[]{"--peerTableName=" + peerTableName.getNameAsString(), UTIL2.getClusterKey(), tableName.getNameAsString()};
        this.runVerifyReplication(args, 100, 0);
        UTIL2.deleteTableData(peerTableName);
        this.runVerifyReplication(args, 0, 100);
    }

    @Test
    public void testVerifyRepJobWithPeerTableNameAndSnapshotSupport() throws Exception {
        TestVerifyReplication.runBatchCopyTest();
        Path rootDir = FSUtils.getRootDir((Configuration)CONF1);
        FileSystem fs = rootDir.getFileSystem(CONF1);
        String sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL1.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])noRepfamName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        Path peerRootDir = FSUtils.getRootDir((Configuration)CONF2);
        FileSystem peerFs = peerRootDir.getFileSystem(CONF2);
        String peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL2.getAdmin(), (TableName)peerTableName, (String)Bytes.toString((byte[])noRepfamName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        String peerFSAddress = peerFs.getUri().toString();
        String tmpPath1 = UTIL1.getRandomDir().toString();
        String tmpPath2 = "/tmp" + System.currentTimeMillis();
        String[] args = new String[]{"--peerTableName=" + peerTableName.getNameAsString(), "--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + tmpPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + tmpPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + FSUtils.getRootDir((Configuration)CONF2), UTIL2.getClusterKey(), tableName.getNameAsString()};
        this.runVerifyReplication(args, 100, 0);
        this.checkRestoreTmpDir(CONF1, tmpPath1, 1);
        this.checkRestoreTmpDir(CONF2, tmpPath2, 1);
        Scan scan = new Scan();
        ResultScanner rs = htable3.getScanner(scan);
        Put put = null;
        for (Result result : rs) {
            put = new Put(result.getRow());
            Cell firstVal = result.rawCells()[0];
            put.addColumn(CellUtil.cloneFamily((Cell)firstVal), CellUtil.cloneQualifier((Cell)firstVal), Bytes.toBytes((String)"diff data"));
            htable3.put(put);
        }
        Delete delete = new Delete(put.getRow());
        htable3.delete(delete);
        sourceSnapshotName = "sourceSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL1.getAdmin(), (TableName)tableName, (String)Bytes.toString((byte[])noRepfamName), (String)sourceSnapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
        peerSnapshotName = "peerSnapshot-" + System.currentTimeMillis();
        SnapshotTestingUtils.createSnapshotAndValidate((Admin)UTIL2.getAdmin(), (TableName)peerTableName, (String)Bytes.toString((byte[])noRepfamName), (String)peerSnapshotName, (Path)peerRootDir, (FileSystem)peerFs, (boolean)true);
        args = new String[]{"--peerTableName=" + peerTableName.getNameAsString(), "--sourceSnapshotName=" + sourceSnapshotName, "--sourceSnapshotTmpDir=" + tmpPath1, "--peerSnapshotName=" + peerSnapshotName, "--peerSnapshotTmpDir=" + tmpPath2, "--peerFSAddress=" + peerFSAddress, "--peerHBaseRootAddress=" + FSUtils.getRootDir((Configuration)CONF2), UTIL2.getClusterKey(), tableName.getNameAsString()};
        this.runVerifyReplication(args, 0, 100);
        this.checkRestoreTmpDir(CONF1, tmpPath1, 2);
        this.checkRestoreTmpDir(CONF2, tmpPath2, 2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        htable3.close();
        TestReplicationBase.tearDownAfterClass();
    }
}

