/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.PerformanceEvaluation;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.GsonUtil;
import org.apache.hbase.thirdparty.com.google.gson.Gson;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestPerformanceEvaluation {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestPerformanceEvaluation.class);
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();

    @Test
    public void testDefaultInMemoryCompaction() {
        PerformanceEvaluation.TestOptions defaultOpts = new PerformanceEvaluation.TestOptions();
        Assert.assertEquals((Object)CompactingMemStore.COMPACTING_MEMSTORE_TYPE_DEFAULT, (Object)defaultOpts.getInMemoryCompaction().toString());
        HTableDescriptor htd = PerformanceEvaluation.getTableDescriptor(defaultOpts);
        for (HColumnDescriptor hcd : htd.getFamilies()) {
            Assert.assertEquals((Object)CompactingMemStore.COMPACTING_MEMSTORE_TYPE_DEFAULT, (Object)hcd.getInMemoryCompaction().toString());
        }
    }

    @Test
    public void testSerialization() {
        PerformanceEvaluation.TestOptions options = new PerformanceEvaluation.TestOptions();
        Assert.assertFalse((boolean)options.isAutoFlush());
        options.setAutoFlush(true);
        Gson gson = GsonUtil.createGson().create();
        String optionsString = gson.toJson((Object)options);
        PerformanceEvaluation.TestOptions optionsDeserialized = (PerformanceEvaluation.TestOptions)gson.fromJson(optionsString, PerformanceEvaluation.TestOptions.class);
        Assert.assertTrue((boolean)optionsDeserialized.isAutoFlush());
    }

    @Test
    public void testWriteInputFile() throws IOException {
        PerformanceEvaluation.TestOptions opts = new PerformanceEvaluation.TestOptions();
        int clients = 10;
        opts.setNumClientThreads(10);
        opts.setPerClientRunRows(10);
        Path dir = PerformanceEvaluation.writeInputFile(HTU.getConfiguration(), opts, HTU.getDataTestDir());
        FileSystem fs = FileSystem.get((Configuration)HTU.getConfiguration());
        Path p = new Path(dir, PerformanceEvaluation.JOB_INPUT_FILENAME);
        long len = fs.getFileStatus(p).getLen();
        Assert.assertTrue((len > 0L ? 1 : 0) != 0);
        byte[] content = new byte[(int)len];
        try (FSDataInputStream dis = fs.open(p);){
            dis.readFully(content);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(content), StandardCharsets.UTF_8));
            int count = 0;
            while (br.readLine() != null) {
                ++count;
            }
            Assert.assertEquals((long)10L, (long)count);
        }
    }

    @Test
    public void testSizeCalculation() {
        PerformanceEvaluation.TestOptions opts = new PerformanceEvaluation.TestOptions();
        opts = PerformanceEvaluation.calculateRowsAndSize(opts);
        int rows = opts.getPerClientRunRows();
        int defaultPerClientRunRows = 0x100000;
        Assert.assertEquals((long)0x100000L, (long)rows);
        opts.setSize(2.0f);
        opts = PerformanceEvaluation.calculateRowsAndSize(opts);
        Assert.assertEquals((long)0x200000L, (long)opts.getPerClientRunRows());
        opts.setNumClientThreads(2);
        opts = PerformanceEvaluation.calculateRowsAndSize(opts);
        Assert.assertEquals((long)0x100000L, (long)opts.getPerClientRunRows());
        opts.valueRandom = true;
        opts = PerformanceEvaluation.calculateRowsAndSize(opts);
        Assert.assertEquals((long)0x200000L, (long)opts.getPerClientRunRows());
    }

    @Test
    public void testRandomReadCalculation() {
        PerformanceEvaluation.TestOptions opts = new PerformanceEvaluation.TestOptions();
        opts = PerformanceEvaluation.calculateRowsAndSize(opts);
        int rows = opts.getPerClientRunRows();
        int defaultPerClientRunRows = 0x100000;
        Assert.assertEquals((long)0x100000L, (long)rows);
        opts.setSize(2.0f);
        opts.setPerClientRunRows(1000);
        opts.setCmdName("randomRead");
        opts = PerformanceEvaluation.calculateRowsAndSize(opts);
        Assert.assertEquals((long)1000L, (long)opts.getPerClientRunRows());
        opts.setNumClientThreads(2);
        opts = PerformanceEvaluation.calculateRowsAndSize(opts);
        Assert.assertEquals((long)1000L, (long)opts.getPerClientRunRows());
        Random random = new Random();
        boolean foundValue = false;
        for (int i = 0; i < 10000000; ++i) {
            int randomRow = PerformanceEvaluation.generateRandomRow(random, opts.totalRows);
            if (randomRow <= 1000) continue;
            foundValue = true;
            break;
        }
        Assert.assertTrue((String)"We need to get a value more than 1000", (boolean)foundValue);
    }

    @Test
    public void testZipfian() throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        PerformanceEvaluation.TestOptions opts = new PerformanceEvaluation.TestOptions();
        opts.setValueZipf(true);
        int valueSize = 1024;
        opts.setValueSize(1024);
        PerformanceEvaluation.RandomReadTest rrt = new PerformanceEvaluation.RandomReadTest(null, opts, null);
        Constructor ctor = Histogram.class.getDeclaredConstructor(Reservoir.class);
        ctor.setAccessible(true);
        Histogram histogram = (Histogram)ctor.newInstance(new UniformReservoir(512000));
        for (int i = 0; i < 100; ++i) {
            histogram.update(rrt.getValueLength(null));
        }
        Snapshot snapshot = histogram.getSnapshot();
        double stddev = snapshot.getStdDev();
        Assert.assertTrue((stddev != 0.0 && stddev != 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((snapshot.getStdDev() != 0.0 ? 1 : 0) != 0);
        double median = snapshot.getMedian();
        Assert.assertTrue((median != 0.0 && median != 1.0 && median != 1024.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSetBufferSizeOption() {
        PerformanceEvaluation.TestOptions opts = new PerformanceEvaluation.TestOptions();
        long bufferSize = opts.getBufferSize();
        Assert.assertEquals((long)bufferSize, (long)0x200000L);
        opts.setBufferSize(65536L);
        bufferSize = opts.getBufferSize();
        Assert.assertEquals((long)bufferSize, (long)65536L);
    }

    @Test
    public void testParseOptsWithThreads() {
        LinkedList<String> opts = new LinkedList<String>();
        String cmdName = "sequentialWrite";
        int threads = 1;
        opts.offer(cmdName);
        opts.offer(String.valueOf(threads));
        PerformanceEvaluation.TestOptions options = PerformanceEvaluation.parseOpts(opts);
        Assert.assertNotNull((Object)options);
        Assert.assertNotNull((Object)options.getCmdName());
        Assert.assertEquals((Object)cmdName, (Object)options.getCmdName());
        Assert.assertEquals((long)threads, (long)options.getNumClientThreads());
    }

    @Test
    public void testParseOptsWrongThreads() {
        LinkedList<String> opts = new LinkedList<String>();
        String cmdName = "sequentialWrite";
        opts.offer(cmdName);
        opts.offer("qq");
        try {
            PerformanceEvaluation.parseOpts(opts);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            Assert.assertEquals((Object)("Command " + cmdName + " does not have threads number"), (Object)e.getMessage());
            Assert.assertTrue((boolean)(e.getCause() instanceof NumberFormatException));
        }
    }

    @Test
    public void testParseOptsNoThreads() {
        LinkedList<String> opts = new LinkedList<String>();
        String cmdName = "sequentialWrite";
        try {
            PerformanceEvaluation.parseOpts(opts);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
            Assert.assertEquals((Object)("Command " + cmdName + " does not have threads number"), (Object)e.getMessage());
            Assert.assertTrue((boolean)(e.getCause() instanceof NoSuchElementException));
        }
    }

    @Test
    public void testParseOptsMultiPuts() {
        LinkedList<String> opts = new LinkedList<String>();
        String cmdName = "sequentialWrite";
        opts.offer("--multiPut=10");
        opts.offer(cmdName);
        opts.offer("64");
        PerformanceEvaluation.TestOptions options = null;
        try {
            options = PerformanceEvaluation.parseOpts(opts);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        opts.offerFirst("--multiPut=10");
        opts.offerFirst("--autoFlush=true");
        options = PerformanceEvaluation.parseOpts(opts);
        Assert.assertNotNull((Object)options);
        Assert.assertNotNull((Object)options.getCmdName());
        Assert.assertEquals((Object)cmdName, (Object)options.getCmdName());
        Assert.assertEquals((long)10L, (long)options.getMultiPut());
    }

    @Test
    public void testParseOptsConnCount() {
        LinkedList<String> opts = new LinkedList<String>();
        String cmdName = "sequentialWrite";
        opts.offer("--oneCon=true");
        opts.offer("--connCount=10");
        opts.offer(cmdName);
        opts.offer("64");
        PerformanceEvaluation.TestOptions options = null;
        try {
            options = PerformanceEvaluation.parseOpts(opts);
            Assert.fail((String)"should fail");
        }
        catch (IllegalArgumentException e) {
            System.out.println(e.getMessage());
        }
        opts.offerFirst("--connCount=10");
        options = PerformanceEvaluation.parseOpts(opts);
        Assert.assertNotNull((Object)options);
        Assert.assertNotNull((Object)options.getCmdName());
        Assert.assertEquals((Object)cmdName, (Object)options.getCmdName());
        Assert.assertEquals((long)10L, (long)options.getConnCount());
    }
}

