/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.logging;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.logging.HBaseTestOutputStreamManager;
import org.apache.hadoop.hbase.logging.Target;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.appender.rolling.FileSize;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;

@Plugin(name="HBaseTest", category="Core", elementType="appender", printObject=true)
public final class HBaseTestAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    public static final String PLUGIN_NAME = "HBaseTest";
    private static final HBaseTestManagerFactory FACTORY = new HBaseTestManagerFactory();
    private final long maxSize;
    private final AtomicLong size = new AtomicLong(0L);
    private final AtomicBoolean stop = new AtomicBoolean(false);

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Object)((Builder)new Builder().asBuilder()));
    }

    private HBaseTestAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, Property[] properties, OutputStreamManager manager, long maxSize) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, manager);
        this.maxSize = maxSize;
    }

    public void append(LogEvent event) {
        if (this.stop.get()) {
            return;
        }
        byte[] bytes = this.getLayout().toByteArray(event);
        if (bytes == null || bytes.length == 0) {
            return;
        }
        long sizeAfterAppend = this.size.addAndGet(bytes.length);
        if (sizeAfterAppend >= this.maxSize) {
            if (this.stop.compareAndSet(false, true)) {
                LOGGER.error("Log size exceeded the limit {}, will stop logging to prevent eating too much disk space", (Object)this.maxSize);
            }
            return;
        }
        super.append(event);
    }

    private static class HBaseTestManagerFactory
    implements ManagerFactory<HBaseTestOutputStreamManager, FactoryData> {
        private HBaseTestManagerFactory() {
        }

        public HBaseTestOutputStreamManager createManager(String name, FactoryData data) {
            return new HBaseTestOutputStreamManager(data.target, data.layout);
        }
    }

    private static class FactoryData {
        private final Target target;
        private final Layout<? extends Serializable> layout;

        public FactoryData(Target target, Layout<? extends Serializable> layout) {
            this.target = target;
            this.layout = layout;
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<HBaseTestAppender> {
        @PluginBuilderAttribute
        @Required
        private Target target;
        @PluginBuilderAttribute
        @Required
        private String maxSize;

        public B setTarget(Target target) {
            this.target = target;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public B setMaxSize(String maxSize) {
            this.maxSize = maxSize;
            return (B)((Object)((Builder)this.asBuilder()));
        }

        public HBaseTestAppender build() {
            long size = FileSize.parse((String)this.maxSize, (long)-1L);
            if (size <= 0L) {
                LOGGER.error("Invalid maxSize {}", (Object)size);
            }
            Layout layout = this.getOrCreateLayout(StandardCharsets.UTF_8);
            OutputStreamManager manager = (OutputStreamManager)OutputStreamManager.getManager((String)this.target.name(), (ManagerFactory)FACTORY, (Object)new FactoryData(this.target, (Layout<? extends Serializable>)layout));
            return new HBaseTestAppender(this.getName(), layout, this.getFilter(), this.isIgnoreExceptions(), this.isImmediateFlush(), this.getPropertyArray(), manager, size);
        }
    }
}

