/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Writer;
import org.apache.log4j.Layout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.helpers.QuietWriter;

public class FileAppender
extends WriterAppender {
    protected boolean fileAppend = true;
    protected String fileName = null;
    protected boolean bufferedIO = false;
    protected int bufferSize = 8192;

    public FileAppender() {
    }

    public FileAppender(Layout layout, String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        this.layout = layout;
        this.setFile(fileName, append, bufferedIO, bufferSize);
    }

    public FileAppender(Layout layout, String fileName, boolean append) throws IOException {
        this.layout = layout;
        this.setFile(fileName, append, false, this.bufferSize);
    }

    public FileAppender(Layout layout, String fileName) throws IOException {
        this(layout, fileName, true);
    }

    public void setFile(String file) {
        String val;
        this.fileName = val = file.trim();
    }

    public boolean getAppend() {
        return this.fileAppend;
    }

    public String getFile() {
        return this.fileName;
    }

    public void activateOptions() {
        if (this.fileName != null) {
            try {
                this.setFile(this.fileName, this.fileAppend, this.bufferedIO, this.bufferSize);
            }
            catch (IOException e) {
                this.errorHandler.error("setFile(" + this.fileName + "," + this.fileAppend + ") call failed.", (Exception)e, 4);
            }
        }
    }

    protected void closeFile() {
        block3: {
            if (this.qw != null) {
                try {
                    this.qw.close();
                }
                catch (IOException e) {
                    if (!(e instanceof InterruptedIOException)) break block3;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public boolean getBufferedIO() {
        return this.bufferedIO;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setAppend(boolean flag) {
        this.fileAppend = flag;
    }

    public void setBufferedIO(boolean bufferedIO) {
        this.bufferedIO = bufferedIO;
        if (bufferedIO) {
            this.immediateFlush = false;
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        if (bufferedIO) {
            this.setImmediateFlush(false);
        }
        this.reset();
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(fileName, append);
        }
        catch (FileNotFoundException ex) {
            String parentName = new File(fileName).getParent();
            if (parentName != null) {
                File parentDir = new File(parentName);
                if (!parentDir.exists() && parentDir.mkdirs()) {
                    ostream = new FileOutputStream(fileName, append);
                }
                throw ex;
            }
            throw ex;
        }
        Writer fw = this.createWriter(ostream);
        if (bufferedIO) {
            fw = new BufferedWriter(fw, bufferSize);
        }
        this.setQWForFiles(fw);
        this.fileName = fileName;
        this.fileAppend = append;
        this.bufferedIO = bufferedIO;
        this.bufferSize = bufferSize;
        this.writeHeader();
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new QuietWriter(writer, this.errorHandler);
    }

    protected void reset() {
        this.closeFile();
        this.fileName = null;
        super.reset();
    }
}

