/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http.prometheus;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.prometheus.PrometheusHadoopServlet;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class, MiscTests.class})
public class TestPrometheusServlet {
    @ClassRule
    public static final HBaseClassTestRule CLASS_TEST_RULE = HBaseClassTestRule.forClass(TestPrometheusServlet.class);

    @Test
    public void testPublish() throws IOException {
        MetricsSystem metrics = DefaultMetricsSystem.instance();
        metrics.init("test");
        TestMetrics testMetrics = (TestMetrics)metrics.register("TestMetrics", "Testing metrics", (Object)new TestMetrics());
        metrics.start();
        testMetrics.numBucketCreateFails.incr();
        metrics.publishMetricsNow();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
        PrometheusHadoopServlet prom2Servlet = new PrometheusHadoopServlet();
        prom2Servlet.writeMetrics((Writer)writer, false, null);
        String writtenMetrics = stream.toString(StandardCharsets.UTF_8.name());
        System.out.println(writtenMetrics);
        Assert.assertTrue((String)"The expected metric line is missing from prometheus metrics output", (boolean)writtenMetrics.contains("test_metrics_num_bucket_create_fails{context=\"dfs\""));
        metrics.stop();
        metrics.shutdown();
    }

    @Metrics(about="Test Metrics", context="dfs")
    private static class TestMetrics {
        @Metric
        private MutableCounterLong numBucketCreateFails;

        private TestMetrics() {
        }
    }
}

