/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.http.TestHttpServer;
import org.apache.hadoop.hbase.http.resource.JerseyResource;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")})
@CreateDS(allowAnonAccess=true, partitions={@CreatePartition(name="Test_Partition", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com \ndc: example\nobjectClass: top\nobjectClass: domain\n\n"))})
@ApplyLdifs(value={"dn: uid=bjones,dc=example,dc=com", "cn: Bob Jones", "sn: Jones", "objectClass: inetOrgPerson", "uid: bjones", "userPassword: p@ssw0rd"})
public class TestLdapHttpServer
extends HttpServerFunctionalTest {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLdapHttpServer.class);
    @ClassRule
    public static CreateLdapServerRule serverRule = new CreateLdapServerRule();
    private static final Logger LOG = LoggerFactory.getLogger(TestLdapHttpServer.class);
    private static HttpServer server;
    private static URL baseUrl;

    @BeforeClass
    public static void setupServer() throws Exception {
        Configuration conf = new Configuration();
        TestLdapHttpServer.buildLdapConfiguration(conf);
        server = TestLdapHttpServer.createTestServer(conf);
        server.addUnprivilegedServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        server.addJerseyResourcePackage(JerseyResource.class.getPackage().getName(), "/jersey/*");
        server.start();
        baseUrl = TestLdapHttpServer.getServerURL(server);
        LOG.info("HTTP server started: " + baseUrl);
    }

    @AfterClass
    public static void stopServer() throws Exception {
        try {
            if (null != server) {
                server.stop();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to stop info server", (Throwable)e);
        }
    }

    private static Configuration buildLdapConfiguration(Configuration conf) {
        conf.setInt("hbase.http.max.threads", 16);
        conf.set("hbase.security.authentication.ui", "ldap");
        conf.set("hbase.http.filter.initializers", "org.apache.hadoop.hbase.http.lib.AuthenticationFilterInitializer");
        conf.set("hadoop.http.authentication.type", "ldap");
        conf.set("hadoop.http.authentication.ldap.providerurl", String.format("ldap://%s:%s", "localhost", serverRule.getLdapServer().getPort()));
        conf.set("hadoop.http.authentication.ldap.enablestarttls", "false");
        conf.set("hadoop.http.authentication.ldap.basedn", "dc=example,dc=com");
        return conf;
    }

    @Test
    public void testUnauthorizedClientsDisallowed() throws IOException {
        URL url = new URL(TestLdapHttpServer.getServerURL(server), "/echo?a=b");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Assert.assertEquals((long)401L, (long)conn.getResponseCode());
    }

    @Test
    public void testAllowedClient() throws IOException {
        URL url = new URL(TestLdapHttpServer.getServerURL(server), "/echo?a=b");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Base64 base64 = new Base64(0);
        String userCredentials = "bjones:p@ssw0rd";
        String basicAuth = "Basic " + base64.encodeToString(userCredentials.getBytes());
        conn.setRequestProperty("Authorization", basicAuth);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
    }

    @Test
    public void testWrongAuthClientsDisallowed() throws IOException {
        URL url = new URL(TestLdapHttpServer.getServerURL(server), "/echo?a=b");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        Base64 base64 = new Base64(0);
        String userCredentials = "bjones:password";
        String basicAuth = "Basic " + base64.encodeToString(userCredentials.getBytes());
        conn.setRequestProperty("Authorization", basicAuth);
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }
}

