/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.LdapServerTestBase;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")})
@CreateDS(name="TestLdapHttpServer", allowAnonAccess=true, partitions={@CreatePartition(name="Test_Partition", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com \ndc: example\nobjectClass: top\nobjectClass: domain\n\n"))})
@ApplyLdifs(value={"dn: uid=bjones,dc=example,dc=com", "cn: Bob Jones", "sn: Jones", "objectClass: inetOrgPerson", "uid: bjones", "userPassword: p@ssw0rd"})
public class TestLdapHttpServer
extends LdapServerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLdapHttpServer.class);
    private static final String BJONES_CREDENTIALS = "bjones:p@ssw0rd";
    private static final String WRONG_CREDENTIALS = "bjones:password";

    @Test
    public void testUnauthorizedClientsDisallowed() throws IOException {
        HttpURLConnection conn = this.openConnection("/echo?a=b", null);
        Assert.assertEquals((long)401L, (long)conn.getResponseCode());
    }

    @Test
    public void testAllowedClient() throws IOException {
        HttpURLConnection conn = this.openConnection("/echo?a=b", BJONES_CREDENTIALS);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
    }

    @Test
    public void testWrongAuthClientsDisallowed() throws IOException {
        HttpURLConnection conn = this.openConnection("/echo?a=b", WRONG_CREDENTIALS);
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }
}

