/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.ApplyLdifs;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.http.LdapServerTestBase;
import org.apache.hadoop.hbase.http.TestHttpServer;
import org.apache.hadoop.hbase.http.resource.JerseyResource;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", address="localhost")})
@CreateDS(name="TestLdapAdminACL", allowAnonAccess=true, partitions={@CreatePartition(name="Test_Partition", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com \ndc: example\nobjectClass: top\nobjectClass: domain\n\n"))})
@ApplyLdifs(value={"dn: uid=bjones,dc=example,dc=com", "cn: Bob Jones", "sn: Jones", "objectClass: inetOrgPerson", "uid: bjones", "userPassword: p@ssw0rd", "dn: uid=jdoe,dc=example,dc=com", "cn: John Doe", "sn: Doe", "objectClass: inetOrgPerson", "uid: jdoe", "userPassword: secure123"})
public class TestLdapAdminACL
extends LdapServerTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLdapAdminACL.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestLdapAdminACL.class);
    private static final String ADMIN_CREDENTIALS = "bjones:p@ssw0rd";
    private static final String NON_ADMIN_CREDENTIALS = "jdoe:secure123";
    private static final String WRONG_CREDENTIALS = "bjones:password";

    @BeforeClass
    public static void setupServer() throws Exception {
        Configuration conf = new Configuration();
        TestLdapAdminACL.setLdapConfigurationWithACLs(conf);
        server = TestLdapAdminACL.createTestServer(conf, InfoServer.buildAdminAcl((Configuration)conf));
        server.addUnprivilegedServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        server.addJerseyResourcePackage(JerseyResource.class.getPackage().getName(), "/jersey/*");
        server.start();
        baseUrl = TestLdapAdminACL.getServerURL(server);
        LOG.info("HTTP server started: " + baseUrl);
    }

    private static void setLdapConfigurationWithACLs(Configuration conf) {
        TestLdapAdminACL.setLdapConfigurations(conf);
        conf.setBoolean("hadoop.security.authorization", true);
        conf.setBoolean("hadoop.security.instrumentation.requires.admin", true);
        conf.set("hbase.security.authentication.ldap.admin.users", "bjones");
    }

    @Test
    public void testAdminAllowedUnprivilegedServletAccess() throws IOException {
        HttpURLConnection conn = this.openConnection("/echo?a=b", ADMIN_CREDENTIALS);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
    }

    @Test
    public void testAdminAllowedPrivilegedServletAccess() throws IOException {
        HttpURLConnection conn = this.openConnection("/jmx", ADMIN_CREDENTIALS);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
    }

    @Test
    public void testNonAdminAllowedUnprivilegedServletAccess() throws IOException {
        HttpURLConnection conn = this.openConnection("/echo?a=b", NON_ADMIN_CREDENTIALS);
        Assert.assertEquals((long)200L, (long)conn.getResponseCode());
    }

    @Test
    public void testNonAdminDisallowedPrivilegedServletAccess() throws IOException {
        HttpURLConnection conn = this.openConnection("/jmx", NON_ADMIN_CREDENTIALS);
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }

    @Test
    public void testWrongAuthDisallowedUnprivilegedServletAccess() throws IOException {
        HttpURLConnection conn = this.openConnection("/echo?a=b", WRONG_CREDENTIALS);
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }

    @Test
    public void testWrongAuthDisallowedPrivilegedServletAccess() throws IOException {
        HttpURLConnection conn = this.openConnection("/jmx", WRONG_CREDENTIALS);
        Assert.assertEquals((long)403L, (long)conn.getResponseCode());
    }
}

