/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.directory.server.core.integ.CreateLdapServerRule;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.http.HttpServerFunctionalTest;
import org.apache.hadoop.hbase.http.TestHttpServer;
import org.apache.hadoop.hbase.http.resource.JerseyResource;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapServerTestBase
extends HttpServerFunctionalTest {
    private static final Logger LOG = LoggerFactory.getLogger(LdapServerTestBase.class);
    @ClassRule
    public static CreateLdapServerRule ldapRule = new CreateLdapServerRule();
    protected static HttpServer server;
    protected static URL baseUrl;
    private static final String AUTH_TYPE = "Basic ";

    @BeforeClass
    public static void setupServer() throws Exception {
        Configuration conf = new Configuration();
        LdapServerTestBase.setLdapConfigurations(conf);
        server = LdapServerTestBase.createTestServer(conf);
        server.addUnprivilegedServlet("echo", "/echo", TestHttpServer.EchoServlet.class);
        server.addJerseyResourcePackage(JerseyResource.class.getPackage().getName(), "/jersey/*");
        server.start();
        baseUrl = LdapServerTestBase.getServerURL(server);
        LOG.info("HTTP server started: " + baseUrl);
    }

    @AfterClass
    public static void stopServer() throws Exception {
        try {
            if (null != server) {
                server.stop();
            }
        }
        catch (Exception e) {
            LOG.info("Failed to stop info server", (Throwable)e);
        }
    }

    protected static void setLdapConfigurations(Configuration conf) {
        conf.setInt("hbase.http.max.threads", 16);
        conf.set("hbase.security.authentication.ui", "ldap");
        conf.set("hbase.http.filter.initializers", "org.apache.hadoop.hbase.http.lib.AuthenticationFilterInitializer");
        conf.set("hadoop.http.authentication.type", "ldap");
        conf.set("hadoop.http.authentication.ldap.providerurl", String.format("ldap://%s:%s", "localhost", ldapRule.getLdapServer().getPort()));
        conf.set("hadoop.http.authentication.ldap.enablestarttls", "false");
        conf.set("hadoop.http.authentication.ldap.basedn", "dc=example,dc=com");
    }

    private String getBasicAuthHeader(String credentials) {
        return AUTH_TYPE + new Base64(0).encodeToString(credentials.getBytes());
    }

    protected HttpURLConnection openConnection(String endpoint, String credentials) throws IOException {
        URL url = new URL(LdapServerTestBase.getServerURL(server) + endpoint);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (credentials != null) {
            conn.setRequestProperty("Authorization", this.getBasicAuthHeader(credentials));
        }
        return conn;
    }
}

