/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.field;

import java.util.EnumMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.field.FieldInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.field.FieldScreenPresenter;
import org.apache.hadoop.hbase.hbtop.screen.field.FieldScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenView;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@Category(value={SmallTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class TestFieldScreenPresenter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFieldScreenPresenter.class);
    @Mock
    private FieldScreenView fieldScreenView;
    private int sortFieldPosition = -1;
    private List<Field> fields;
    private EnumMap<Field, Boolean> fieldDisplayMap;
    @Mock
    private FieldScreenPresenter.ResultListener resultListener;
    @Mock
    private TopScreenView topScreenView;
    private FieldScreenPresenter fieldScreenPresenter;

    @Before
    public void setup() {
        Field sortField = Mode.REGION.getDefaultSortField();
        this.fields = Mode.REGION.getFieldInfos().stream().map(FieldInfo::getField).collect(Collectors.toList());
        this.fieldDisplayMap = Mode.REGION.getFieldInfos().stream().collect(() -> new EnumMap(Field.class), (r, fi) -> r.put(fi.getField(), fi.isDisplayByDefault()), (r1, r2) -> {});
        this.fieldScreenPresenter = new FieldScreenPresenter(this.fieldScreenView, sortField, this.fields, this.fieldDisplayMap, this.resultListener, (ScreenView)this.topScreenView);
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            if (field != sortField) continue;
            this.sortFieldPosition = i;
            break;
        }
    }

    @Test
    public void testInit() {
        this.fieldScreenPresenter.init();
        int modeHeaderMaxLength = "#COMPingCell".length();
        int modeDescriptionMaxLength = "Filtered Read Request Count per second".length();
        ((FieldScreenView)Mockito.verify((Object)this.fieldScreenView)).showFieldScreen((String)ArgumentMatchers.eq((Object)"#REQ/S"), (List)ArgumentMatchers.eq(this.fields), (EnumMap)ArgumentMatchers.eq(this.fieldDisplayMap), ArgumentMatchers.eq((int)this.sortFieldPosition), ArgumentMatchers.eq((int)modeHeaderMaxLength), ArgumentMatchers.eq((int)modeDescriptionMaxLength), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void testChangeSortField() {
        this.fieldScreenPresenter.arrowUp();
        this.fieldScreenPresenter.setSortField();
        this.fieldScreenPresenter.arrowDown();
        this.fieldScreenPresenter.arrowDown();
        this.fieldScreenPresenter.setSortField();
        this.fieldScreenPresenter.pageUp();
        this.fieldScreenPresenter.setSortField();
        this.fieldScreenPresenter.pageDown();
        this.fieldScreenPresenter.setSortField();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fieldScreenView});
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showScreenDescription((String)ArgumentMatchers.eq((Object)"LRS"));
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showScreenDescription((String)ArgumentMatchers.eq((Object)"#READ/S"));
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showScreenDescription((String)ArgumentMatchers.eq((Object)this.fields.get(0).getHeader()));
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showScreenDescription((String)ArgumentMatchers.eq((Object)this.fields.get(this.fields.size() - 1).getHeader()));
    }

    @Test
    public void testSwitchFieldDisplay() {
        this.fieldScreenPresenter.switchFieldDisplay();
        this.fieldScreenPresenter.switchFieldDisplay();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.fieldScreenView});
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showField(ArgumentMatchers.anyInt(), (Field)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)false), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean());
        ((FieldScreenView)inOrder.verify((Object)this.fieldScreenView)).showField(ArgumentMatchers.anyInt(), (Field)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testChangeFieldsOrder() {
        this.fieldScreenPresenter.turnOnMoveMode();
        this.fieldScreenPresenter.arrowUp();
        this.fieldScreenPresenter.turnOffMoveMode();
        Field removed = this.fields.remove(this.sortFieldPosition);
        this.fields.add(this.sortFieldPosition - 1, removed);
        MatcherAssert.assertThat((Object)this.fieldScreenPresenter.transitionToNextScreen(), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((FieldScreenPresenter.ResultListener)Mockito.verify((Object)this.resultListener)).accept((Field)ArgumentMatchers.any(), (List)ArgumentMatchers.eq(this.fields), (EnumMap)ArgumentMatchers.any());
    }
}

