/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.mode;

import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.hbtop.Record;
import org.apache.hadoop.hbase.hbtop.RecordFilter;
import org.apache.hadoop.hbase.hbtop.TestUtils;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.mode.DrillDownInfo;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.mode.TestModeBase;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestClientMode
extends TestModeBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientMode.class);

    @Override
    protected Mode getMode() {
        return Mode.CLIENT;
    }

    @Override
    protected void assertRecords(List<Record> records) {
        TestUtils.assertRecordsInClientMode(records);
    }

    @Override
    protected void assertDrillDown(Record currentRecord, DrillDownInfo drillDownInfo) {
        String client;
        MatcherAssert.assertThat((Object)drillDownInfo.getNextMode(), (Matcher)CoreMatchers.is((Object)Mode.USER));
        MatcherAssert.assertThat((Object)drillDownInfo.getInitialFilters().size(), (Matcher)CoreMatchers.is((Object)1));
        switch (client = currentRecord.get((Object)Field.CLIENT).asString()) {
            case "CLIENT_A_FOO": {
                MatcherAssert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"CLIENT==CLIENT_A_FOO"));
                break;
            }
            case "CLIENT_B_FOO": {
                MatcherAssert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"CLIENT==CLIENT_B_FOO"));
                break;
            }
            case "CLIENT_A_BAR": {
                MatcherAssert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"CLIENT==CLIENT_A_BAR"));
                break;
            }
            case "CLIENT_B_BAR": {
                MatcherAssert.assertThat((Object)((RecordFilter)drillDownInfo.getInitialFilters().get(0)).toString(), (Matcher)CoreMatchers.is((Object)"CLIENT==CLIENT_B_BAR"));
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }
}

