/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.mode;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.hbtop.mode.Mode;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.mode.ModeScreenPresenter;
import org.apache.hadoop.hbase.hbtop.screen.mode.ModeScreenView;
import org.apache.hadoop.hbase.hbtop.screen.top.TopScreenView;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class TestModeScreenPresenter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestModeScreenPresenter.class);
    @Mock
    private ModeScreenView modeScreenView;
    @Mock
    private TopScreenView topScreenView;
    @Mock
    private Consumer<Mode> resultListener;

    private ModeScreenPresenter createModeScreenPresenter(Mode currentMode) {
        return new ModeScreenPresenter(this.modeScreenView, currentMode, this.resultListener, (ScreenView)this.topScreenView);
    }

    @Test
    public void testInit() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.init();
        int modeHeaderMaxLength = Mode.REGION_SERVER.getHeader().length();
        int modeDescriptionMaxLength = Mode.REGION_SERVER.getDescription().length();
        ((ModeScreenView)Mockito.verify((Object)this.modeScreenView)).showModeScreen((Mode)ArgumentMatchers.eq((Object)Mode.REGION), (List)ArgumentMatchers.eq(Arrays.asList(Mode.values())), ArgumentMatchers.eq((int)Mode.REGION.ordinal()), ArgumentMatchers.eq((int)modeHeaderMaxLength), ArgumentMatchers.eq((int)modeDescriptionMaxLength));
    }

    @Test
    public void testSelectNamespaceMode() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.arrowUp();
        modeScreenPresenter.arrowUp();
        MatcherAssert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((Consumer)Mockito.verify(this.resultListener)).accept(ArgumentMatchers.eq((Object)Mode.NAMESPACE));
    }

    @Test
    public void testSelectTableMode() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.arrowUp();
        MatcherAssert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((Consumer)Mockito.verify(this.resultListener)).accept(ArgumentMatchers.eq((Object)Mode.TABLE));
    }

    @Test
    public void testSelectRegionMode() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.NAMESPACE);
        modeScreenPresenter.arrowDown();
        modeScreenPresenter.arrowDown();
        MatcherAssert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((Consumer)Mockito.verify(this.resultListener)).accept(ArgumentMatchers.eq((Object)Mode.REGION));
    }

    @Test
    public void testSelectRegionServerMode() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.arrowDown();
        MatcherAssert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((Consumer)Mockito.verify(this.resultListener)).accept(ArgumentMatchers.eq((Object)Mode.REGION_SERVER));
    }

    @Test
    public void testCancelSelectingMode() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.arrowDown();
        modeScreenPresenter.arrowDown();
        MatcherAssert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(false), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((Consumer)Mockito.verify(this.resultListener, (VerificationMode)Mockito.never())).accept(ArgumentMatchers.any());
    }

    @Test
    public void testPageUp() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.pageUp();
        MatcherAssert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        ((Consumer)Mockito.verify(this.resultListener)).accept(ArgumentMatchers.eq((Object)Mode.values()[0]));
    }

    @Test
    public void testPageDown() {
        ModeScreenPresenter modeScreenPresenter = this.createModeScreenPresenter(Mode.REGION);
        modeScreenPresenter.pageDown();
        MatcherAssert.assertThat((Object)modeScreenPresenter.transitionToNextScreen(true), (Matcher)CoreMatchers.is((Object)this.topScreenView));
        Mode[] modes = Mode.values();
        ((Consumer)Mockito.verify(this.resultListener)).accept(ArgumentMatchers.eq((Object)modes[modes.length - 1]));
    }
}

