/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsTableSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestMetricsTableSourceImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsTableSourceImpl.class);

    @Test
    public void testCompareToHashCode() throws Exception {
        MetricsRegionServerSourceFactory metricsFact = (MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class);
        MetricsTableSource one = metricsFact.createTable("ONETABLE", (MetricsTableWrapperAggregate)new TableWrapperStub("ONETABLE"));
        MetricsTableSource oneClone = metricsFact.createTable("ONETABLE", (MetricsTableWrapperAggregate)new TableWrapperStub("ONETABLE"));
        MetricsTableSource two = metricsFact.createTable("TWOTABLE", (MetricsTableWrapperAggregate)new TableWrapperStub("TWOTABLE"));
        Assert.assertEquals((long)0L, (long)one.compareTo((Object)oneClone));
        Assert.assertEquals((long)one.hashCode(), (long)oneClone.hashCode());
        Assert.assertNotEquals((Object)one, (Object)two);
        Assert.assertTrue((one.compareTo((Object)two) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo((Object)one) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo((Object)one) != one.compareTo((Object)two) ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo((Object)two) == 0 ? 1 : 0) != 0);
    }

    @Test(expected=RuntimeException.class)
    public void testNoGetTableMetricsSourceImpl() throws Exception {
        CompatibilitySingletonFactory.getInstance(MetricsTableSourceImpl.class);
    }

    @Test
    public void testGetTableMetrics() throws Exception {
        MetricsTableSource oneTbl = ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).createTable("ONETABLE", (MetricsTableWrapperAggregate)new TableWrapperStub("ONETABLE"));
        Assert.assertEquals((Object)"ONETABLE", (Object)oneTbl.getTableName());
    }

    static class TableWrapperStub
    implements MetricsTableWrapperAggregate {
        private String tableName;

        public TableWrapperStub(String tableName) {
            this.tableName = tableName;
        }

        public long getReadRequestsCount(String table) {
            return 10L;
        }

        public long getWriteRequestsCount(String table) {
            return 20L;
        }

        public long getTotalRequestsCount(String table) {
            return 30L;
        }

        public long getMemStoresSize(String table) {
            return 1000L;
        }

        public long getStoreFilesSize(String table) {
            return 2000L;
        }

        public long getTableSize(String table) {
            return 3000L;
        }

        public String getTableName() {
            return this.tableName;
        }
    }
}

