/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.hbase.testclassification.MetricsTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetricsTests.class, SmallTests.class})
public class TestMetricsRegionSourceImpl {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMetricsRegionSourceImpl.class);

    @Test
    public void testCompareToHashCodeEquals() throws Exception {
        MetricsRegionServerSourceFactory fact = (MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class);
        MetricsRegionSource one = fact.createRegion((MetricsRegionWrapper)new RegionWrapperStub("TEST"));
        MetricsRegionSource oneClone = fact.createRegion((MetricsRegionWrapper)new RegionWrapperStub("TEST"));
        MetricsRegionSource two = fact.createRegion((MetricsRegionWrapper)new RegionWrapperStub("TWO"));
        Assert.assertEquals((long)0L, (long)one.compareTo((Object)oneClone));
        Assert.assertEquals((long)one.hashCode(), (long)oneClone.hashCode());
        Assert.assertNotEquals((Object)one, (Object)two);
        Assert.assertTrue((one.compareTo((Object)two) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo((Object)one) != 0 ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo((Object)one) != one.compareTo((Object)two) ? 1 : 0) != 0);
        Assert.assertTrue((two.compareTo((Object)two) == 0 ? 1 : 0) != 0);
    }

    @Test(expected=RuntimeException.class)
    public void testNoGetRegionServerMetricsSourceImpl() throws Exception {
        CompatibilitySingletonFactory.getInstance(MetricsRegionSource.class);
    }

    static class RegionWrapperStub
    implements MetricsRegionWrapper {
        private String regionName;

        public RegionWrapperStub(String regionName) {
            this.regionName = regionName;
        }

        public String getTableName() {
            return null;
        }

        public String getNamespace() {
            return null;
        }

        public String getRegionName() {
            return this.regionName;
        }

        public long getNumStores() {
            return 0L;
        }

        public long getNumStoreFiles() {
            return 0L;
        }

        public long getMemStoreSize() {
            return 0L;
        }

        public long getStoreFileSize() {
            return 0L;
        }

        public long getReadRequestCount() {
            return 0L;
        }

        public long getFilteredReadRequestCount() {
            return 0L;
        }

        public long getMaxStoreFileAge() {
            return 0L;
        }

        public long getMinStoreFileAge() {
            return 0L;
        }

        public long getAvgStoreFileAge() {
            return 0L;
        }

        public long getNumReferenceFiles() {
            return 0L;
        }

        public long getWriteRequestCount() {
            return 0L;
        }

        public long getNumFilesCompacted() {
            return 0L;
        }

        public long getNumBytesCompacted() {
            return 0L;
        }

        public long getLastMajorCompactionAge() {
            return 0L;
        }

        public long getNumCompactionsCompleted() {
            return 0L;
        }

        public long getNumCompactionsFailed() {
            return 0L;
        }

        public int getRegionHashCode() {
            return this.regionName.hashCode();
        }

        public int getReplicaId() {
            return 0;
        }

        public long getNumCompactionsQueued() {
            return 0L;
        }

        public long getNumFlushesQueued() {
            return 0L;
        }

        public long getMaxCompactionQueueSize() {
            return 0L;
        }

        public long getMaxFlushQueueSize() {
            return 0L;
        }
    }
}

