/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionAggregateSourceImpl;
import org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.DynamicMetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsRegionSourceImpl
implements MetricsRegionSource {
    private static final Log LOG = LogFactory.getLog(MetricsRegionSourceImpl.class);
    private AtomicBoolean closed = new AtomicBoolean(false);
    private MetricsRegionWrapper regionWrapper;
    private final MetricsRegionAggregateSourceImpl agg;
    private final DynamicMetricsRegistry registry;
    private final String regionNamePrefix;
    private final String regionPutKey;
    private final String regionDeleteKey;
    private final String regionGetKey;
    private final String regionIncrementKey;
    private final String regionAppendKey;
    private final String regionScanKey;
    private final MutableFastCounter regionPut;
    private final MutableFastCounter regionDelete;
    private final MutableFastCounter regionIncrement;
    private final MutableFastCounter regionAppend;
    private final MutableFastCounter regionGet;
    private final MutableFastCounter regionScan;
    private final int hashCode;

    public MetricsRegionSourceImpl(MetricsRegionWrapper regionWrapper, MetricsRegionAggregateSourceImpl aggregate) {
        this.regionWrapper = regionWrapper;
        this.agg = aggregate;
        this.hashCode = regionWrapper.getRegionHashCode();
        this.agg.register(this);
        LOG.debug((Object)("Creating new MetricsRegionSourceImpl for table " + regionWrapper.getTableName() + " " + regionWrapper.getRegionName()));
        this.registry = this.agg.getMetricsRegistry();
        this.regionNamePrefix = "Namespace_" + regionWrapper.getNamespace() + "_table_" + regionWrapper.getTableName() + "_region_" + regionWrapper.getRegionName() + "_metric_";
        String suffix = "Count";
        this.regionPutKey = this.regionNamePrefix + "put" + suffix;
        this.regionPut = this.registry.getCounter(this.regionPutKey, 0L);
        this.regionDeleteKey = this.regionNamePrefix + "delete" + suffix;
        this.regionDelete = this.registry.getCounter(this.regionDeleteKey, 0L);
        this.regionIncrementKey = this.regionNamePrefix + "increment" + suffix;
        this.regionIncrement = this.registry.getCounter(this.regionIncrementKey, 0L);
        this.regionAppendKey = this.regionNamePrefix + "append" + suffix;
        this.regionAppend = this.registry.getCounter(this.regionAppendKey, 0L);
        this.regionGetKey = this.regionNamePrefix + "get" + suffix;
        this.regionGet = this.registry.getCounter(this.regionGetKey, 0L);
        this.regionScanKey = this.regionNamePrefix + "scan" + suffix;
        this.regionScan = this.registry.getCounter(this.regionScanKey, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        boolean wasClosed = this.closed.getAndSet(true);
        if (wasClosed) {
            return;
        }
        this.agg.deregister(this);
        MetricsRegionSourceImpl metricsRegionSourceImpl = this;
        synchronized (metricsRegionSourceImpl) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Removing region Metrics: " + this.regionWrapper.getRegionName()));
            }
            this.registry.removeMetric(this.regionPutKey);
            this.registry.removeMetric(this.regionDeleteKey);
            this.registry.removeMetric(this.regionIncrementKey);
            this.registry.removeMetric(this.regionAppendKey);
            this.registry.removeMetric(this.regionGetKey);
            this.registry.removeMetric(this.regionScanKey);
            this.regionWrapper = null;
        }
    }

    public void updatePut() {
        this.regionPut.incr();
    }

    public void updateDelete() {
        this.regionDelete.incr();
    }

    public void updateGet(long mills) {
        this.regionGet.incr();
    }

    public void updateScanTime(long mills) {
        this.regionScan.incr();
    }

    public void updateIncrement() {
        this.regionIncrement.incr();
    }

    public void updateAppend() {
        this.regionAppend.incr();
    }

    public MetricsRegionAggregateSource getAggregateSource() {
        return this.agg;
    }

    public int compareTo(MetricsRegionSource source) {
        if (!(source instanceof MetricsRegionSourceImpl)) {
            return -1;
        }
        MetricsRegionSourceImpl impl = (MetricsRegionSourceImpl)source;
        if (impl == null) {
            return -1;
        }
        return Long.compare(this.hashCode, impl.hashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshot(MetricsRecordBuilder mrb, boolean ignored) {
        if (this.closed.get()) {
            return;
        }
        MetricsRegionSourceImpl metricsRegionSourceImpl = this;
        synchronized (metricsRegionSourceImpl) {
            if (this.closed.get()) {
                return;
            }
            mrb.addGauge(Interns.info(this.regionNamePrefix + "storeCount", "Number of Stores"), this.regionWrapper.getNumStores());
            mrb.addGauge(Interns.info(this.regionNamePrefix + "storeFileCount", "Number of Store Files"), this.regionWrapper.getNumStoreFiles());
            mrb.addGauge(Interns.info(this.regionNamePrefix + "memStoreSize", "Size of the memstore"), this.regionWrapper.getMemstoreSize());
            mrb.addGauge(Interns.info(this.regionNamePrefix + "maxStoreFileAge", "Max age of store files hosted on this region server"), this.regionWrapper.getMaxStoreFileAge());
            mrb.addGauge(Interns.info(this.regionNamePrefix + "minStoreFileAge", "Min age of store files hosted on this region server"), this.regionWrapper.getMinStoreFileAge());
            mrb.addGauge(Interns.info(this.regionNamePrefix + "avgStoreFileAge", "Average age of store files hosted on this region server"), this.regionWrapper.getAvgStoreFileAge());
            mrb.addGauge(Interns.info(this.regionNamePrefix + "numReferenceFiles", "Number of reference file on this region server"), this.regionWrapper.getNumReferenceFiles());
            mrb.addGauge(Interns.info(this.regionNamePrefix + "storeFileSize", "Size of storefiles being served."), this.regionWrapper.getStoreFileSize());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "compactionsCompletedCount", "Number of compactions that have completed."), this.regionWrapper.getNumCompactionsCompleted());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "compactionsFailedCount", "Number of compactions that have failed."), this.regionWrapper.getNumCompactionsFailed());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "lastMajorCompactionAge", "Age of the last major compaction in milliseconds."), this.regionWrapper.getLastMajorCompactionAge());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "numBytesCompactedCount", "Sum of filesize on all files entering a finished, successful or aborted, compaction"), this.regionWrapper.getNumBytesCompacted());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "numFilesCompactedCount", "Number of files that were input for finished, successful or aborted, compactions"), this.regionWrapper.getNumFilesCompacted());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "readRequestCount", "Number of read requests this region server has answered."), this.regionWrapper.getReadRequestCount());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "filteredReadRequestCount", "Number of filtered read requests this region server has answered."), this.regionWrapper.getFilteredReadRequestCount());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "writeRequestCount", "Number of mutation requests this region server has answered."), this.regionWrapper.getWriteRequestCount());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "replicaid", "The replica ID of a region. 0 is primary, otherwise is secondary"), this.regionWrapper.getReplicaId());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "compactionsQueuedCount", "Number of compactions that are queued/running for this region"), this.regionWrapper.getNumCompactionsQueued());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "flushesQueuedCount", "Number flushes requested/queued for this region"), this.regionWrapper.getNumFlushesQueued());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "maxCompactionQueueSize", "Max number of compactions queued for this region"), this.regionWrapper.getMaxCompactionQueueSize());
            mrb.addCounter(Interns.info(this.regionNamePrefix + "maxFlushQueueSize", "Max number of flushes queued for this region"), this.regionWrapper.getMaxFlushQueueSize());
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof MetricsRegionSourceImpl && this.compareTo((MetricsRegionSourceImpl)obj) == 0;
    }
}

