/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import com.yammer.metrics.stats.ExponentiallyDecayingSample;
import com.yammer.metrics.stats.Sample;
import com.yammer.metrics.stats.Snapshot;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableMetric;

@InterfaceAudience.Private
public class MutableHistogram
extends MutableMetric
implements MetricHistogram {
    private static final int DEFAULT_SAMPLE_SIZE = 2046;
    private static final double DEFAULT_ALPHA = 0.015;
    private final String name;
    private final String desc;
    private final Sample sample;
    private final AtomicLong min;
    private final AtomicLong max;
    private final AtomicLong sum;
    private final AtomicLong count;

    public MutableHistogram(MetricsInfo info) {
        this(info.name(), info.description());
    }

    public MutableHistogram(String name, String description) {
        this.name = StringUtils.capitalize((String)name);
        this.desc = StringUtils.uncapitalize((String)description);
        this.sample = new ExponentiallyDecayingSample(2046, 0.015);
        this.count = new AtomicLong();
        this.min = new AtomicLong(Long.MAX_VALUE);
        this.max = new AtomicLong(Long.MIN_VALUE);
        this.sum = new AtomicLong();
    }

    public void add(long val) {
        this.setChanged();
        this.count.incrementAndGet();
        this.sample.update(val);
        this.setMax(val);
        this.setMin(val);
        this.sum.getAndAdd(val);
    }

    private void setMax(long potentialMax) {
        boolean done = false;
        while (!done) {
            long currentMax = this.max.get();
            done = currentMax >= potentialMax || this.max.compareAndSet(currentMax, potentialMax);
        }
    }

    private void setMin(long potentialMin) {
        boolean done = false;
        while (!done) {
            long currentMin = this.min.get();
            done = currentMin <= potentialMin || this.min.compareAndSet(currentMin, potentialMin);
        }
    }

    public long getMax() {
        if (this.count.get() > 0L) {
            return this.max.get();
        }
        return 0L;
    }

    public long getMin() {
        if (this.count.get() > 0L) {
            return this.min.get();
        }
        return 0L;
    }

    public double getMean() {
        long cCount = this.count.get();
        if (cCount > 0L) {
            return (double)this.sum.get() / (double)cCount;
        }
        return 0.0;
    }

    public void snapshot(MetricsRecordBuilder metricsRecordBuilder, boolean all) {
        if (all || this.changed()) {
            this.clearChanged();
            Snapshot s = this.sample.getSnapshot();
            metricsRecordBuilder.addCounter(Interns.info((String)(this.name + "_num_ops"), (String)this.desc), this.count.get());
            metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_min"), (String)this.desc), this.getMin());
            metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_max"), (String)this.desc), this.getMax());
            metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_mean"), (String)this.desc), this.getMean());
            metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_median"), (String)this.desc), s.getMedian());
            metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_75th_percentile"), (String)this.desc), s.get75thPercentile());
            metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_95th_percentile"), (String)this.desc), s.get95thPercentile());
            metricsRecordBuilder.addGauge(Interns.info((String)(this.name + "_99th_percentile"), (String)this.desc), s.get99thPercentile());
        }
    }
}

