/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadLocalRandom;
import net.spy.memcached.CachedData;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.io.hfile.CacheTestUtils;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.MemcachedBlockCache;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Category(value={IOTests.class, SmallTests.class})
public class TestMemcachedBlockCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMemcachedBlockCache.class);
    private MemcachedBlockCache cache;
    private ConcurrentMap<String, CachedData> backingMap;

    @Before
    public void setup() throws Exception {
        final int port = ThreadLocalRandom.current().nextInt(1024, 65536);
        Configuration conf = new Configuration();
        conf.set("hbase.cache.memcached.servers", "localhost:" + port);
        this.backingMap = new ConcurrentHashMap<String, CachedData>();
        this.cache = new MemcachedBlockCache(conf){

            private <T> OperationFuture<T> createFuture(String key, long opTimeout, T result) {
                OperationFuture future = new OperationFuture(key, new CountDownLatch(0), opTimeout, (ExecutorService)ForkJoinPool.commonPool());
                Operation op = (Operation)Mockito.mock(Operation.class);
                Mockito.when((Object)op.getState()).thenReturn((Object)OperationState.COMPLETE);
                future.setOperation(op);
                future.set(result, new OperationStatus(true, ""));
                return future;
            }

            protected MemcachedClient createMemcachedClient(ConnectionFactory factory, List<InetSocketAddress> serverAddresses) throws IOException {
                Assert.assertEquals((Object)FailureMode.Redistribute, (Object)factory.getFailureMode());
                Assert.assertTrue((boolean)factory.isDaemon());
                Assert.assertFalse((boolean)factory.useNagleAlgorithm());
                Assert.assertEquals((long)1044480L, (long)factory.getReadBufSize());
                Assert.assertEquals((long)1L, (long)serverAddresses.size());
                Assert.assertEquals((Object)"localhost", (Object)serverAddresses.get(0).getHostName());
                Assert.assertEquals((long)port, (long)serverAddresses.get(0).getPort());
                MemcachedClient client = (MemcachedClient)Mockito.mock(MemcachedClient.class);
                Mockito.when((Object)client.set(ArgumentMatchers.anyString(), ArgumentMatchers.anyInt(), ArgumentMatchers.any(), (Transcoder)ArgumentMatchers.any())).then(inv -> {
                    String key = (String)inv.getArgument(0);
                    HFileBlock block = (HFileBlock)inv.getArgument(2);
                    Transcoder tc = (Transcoder)inv.getArgument(3);
                    CachedData cd = tc.encode((Object)block);
                    TestMemcachedBlockCache.this.backingMap.put(key, cd);
                    return this.createFuture(key, factory.getOperationTimeout(), true);
                });
                Mockito.when((Object)client.delete(ArgumentMatchers.anyString())).then(inv -> {
                    String key = (String)inv.getArgument(0);
                    TestMemcachedBlockCache.this.backingMap.remove(key);
                    return this.createFuture(key, factory.getOperationTimeout(), true);
                });
                Mockito.when((Object)client.get(ArgumentMatchers.anyString(), (Transcoder)ArgumentMatchers.any())).then(inv -> {
                    String key = (String)inv.getArgument(0);
                    Transcoder tc = (Transcoder)inv.getArgument(1);
                    CachedData cd = (CachedData)TestMemcachedBlockCache.this.backingMap.get(key);
                    return tc.decode(cd);
                });
                return client;
            }
        };
    }

    @Test
    public void testCache() throws Exception {
        int i;
        int numBlocks = 10;
        CacheTestUtils.HFileBlockPair[] blocks = CacheTestUtils.generateHFileBlocks((int)65536, (int)10);
        for (i = 0; i < 10; ++i) {
            this.cache.cacheBlock(blocks[i].getBlockName(), (Cacheable)blocks[i].getBlock());
        }
        Waiter.waitFor((Configuration)new Configuration(), (long)10000L, () -> this.backingMap.size() == 10);
        for (i = 0; i < 10; ++i) {
            HFileBlock actual = (HFileBlock)this.cache.getBlock(blocks[i].getBlockName(), false, false, true);
            HFileBlock expected = blocks[i].getBlock();
            Assert.assertEquals((Object)expected.getBlockType(), (Object)actual.getBlockType());
            Assert.assertEquals((long)expected.getSerializedLength(), (long)actual.getSerializedLength());
        }
    }

    @Test
    public void testEviction() throws Exception {
        int i;
        int numBlocks = 10;
        CacheTestUtils.HFileBlockPair[] blocks = CacheTestUtils.generateHFileBlocks((int)65536, (int)10);
        for (i = 0; i < 10; ++i) {
            this.cache.cacheBlock(blocks[i].getBlockName(), (Cacheable)blocks[i].getBlock());
        }
        Waiter.waitFor((Configuration)new Configuration(), (long)10000L, () -> this.backingMap.size() == 10);
        for (i = 0; i < 10; ++i) {
            this.cache.evictBlock(blocks[i].getBlockName());
        }
        Waiter.waitFor((Configuration)new Configuration(), (long)10000L, () -> this.backingMap.size() == 0);
    }
}

