/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.example.ZooKeeperScanPolicyObserver;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestZooKeeperScanPolicyObserver {
    private static final Log LOG = LogFactory.getLog(TestZooKeeperScanPolicyObserver.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] F = Bytes.toBytes((String)"fam");
    private static final byte[] Q = Bytes.toBytes((String)"qual");
    private static final byte[] R = Bytes.toBytes((String)"row");

    public static void setUpBeforeClass() throws Exception {
        System.out.println("HERE!!!!!!!!");
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{ZooKeeperScanPolicyObserver.class.getName()});
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.startMiniCluster();
    }

    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public void testScanPolicyObserver() throws Exception {
        TableName tableName = TableName.valueOf((String)"testScanPolicyObserver");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(F).setMaxVersions(10).setTimeToLive(1);
        desc.addFamily(hcd);
        TEST_UTIL.getHBaseAdmin().createTable(desc);
        HTable t = new HTable(new Configuration(TEST_UTIL.getConfiguration()), tableName);
        long now = EnvironmentEdgeManager.currentTime();
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "test", null);
        ZooKeeper zk = zkw.getRecoverableZooKeeper().getZooKeeper();
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/backup/example/lastbackup");
        zk.setData("/backup/example/lastbackup", Bytes.toBytes((long)(now - 3600000L)), -1);
        LOG.debug((Object)("Set time: " + Bytes.toLong((byte[])Bytes.toBytes((long)(now - 3600000L)))));
        Thread.sleep(1000L);
        long ts = now - 2000L;
        Put p = new Put(R);
        p.add(F, Q, ts, Q);
        t.put(p);
        p = new Put(R);
        p.add(F, Q, ts + 1L, Q);
        t.put(p);
        Get g = new Get(R);
        g.setMaxVersions(10);
        Result r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        TEST_UTIL.flush(tableName);
        TEST_UTIL.compact(tableName, true);
        g = new Get(R);
        g.setMaxVersions(10);
        r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        zk.setData("/backup/example/lastbackup", Bytes.toBytes((long)now), -1);
        LOG.debug((Object)("Set time: " + now));
        TEST_UTIL.compact(tableName, true);
        g = new Get(R);
        g.setMaxVersions(10);
        r = t.get(g);
        Assert.assertEquals((long)0L, (long)r.size());
        t.close();
    }
}

