/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.example.RowCountEndpoint;
import org.apache.hadoop.hbase.coprocessor.example.generated.ExampleProtos;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestRowCountEndpoint {
    private static final TableName TEST_TABLE = TableName.valueOf((String)"testrowcounter");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f");
    private static final byte[] TEST_COLUMN = Bytes.toBytes((String)"col");
    private static HBaseTestingUtility TEST_UTIL = null;
    private static Configuration CONF = null;

    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        CONF = TEST_UTIL.getConfiguration();
        CONF.setStrings("hbase.coprocessor.region.classes", new String[]{RowCountEndpoint.class.getName()});
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.createTable(TEST_TABLE, (byte[][])new byte[][]{TEST_FAMILY});
    }

    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    public void testEndpoint() throws Throwable {
        HTable table = new HTable(CONF, TEST_TABLE);
        for (int i = 0; i < 5; ++i) {
            byte[] iBytes = Bytes.toBytes((int)i);
            Put p = new Put(iBytes);
            p.add(TEST_FAMILY, TEST_COLUMN, iBytes);
            table.put(p);
        }
        final ExampleProtos.CountRequest request = ExampleProtos.CountRequest.getDefaultInstance();
        Map results = table.coprocessorService(ExampleProtos.RowCountService.class, null, null, (Batch.Call)new Batch.Call<ExampleProtos.RowCountService, Long>(){

            public Long call(ExampleProtos.RowCountService counter) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                BlockingRpcCallback rpcCallback = new BlockingRpcCallback();
                counter.getRowCount((RpcController)controller, request, (RpcCallback)rpcCallback);
                ExampleProtos.CountResponse response = (ExampleProtos.CountResponse)rpcCallback.get();
                if (controller.failedOnException()) {
                    throw controller.getFailedOn();
                }
                return response != null && response.hasCount() ? response.getCount() : 0L;
            }
        });
        Assert.assertEquals((int)1, (int)results.size());
        Iterator iter = results.values().iterator();
        Long val = (Long)iter.next();
        Assert.assertNotNull((Object)val);
        Assert.assertEquals((long)5L, (long)val);
    }
}

