/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.thrift;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.thrift.generated.AlreadyExists;
import org.apache.hadoop.hbase.thrift.generated.ColumnDescriptor;
import org.apache.hadoop.hbase.thrift.generated.Hbase;
import org.apache.hadoop.hbase.thrift.generated.IOError;
import org.apache.hadoop.hbase.thrift.generated.IllegalArgument;
import org.apache.hadoop.hbase.thrift.generated.Mutation;
import org.apache.hadoop.hbase.thrift.generated.TCell;
import org.apache.hadoop.hbase.thrift.generated.TRowResult;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class DemoClient {
    protected static int port;
    protected static String host;
    CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();

    public static void main(String[] args) throws IOError, TException, UnsupportedEncodingException, IllegalArgument, AlreadyExists {
        if (args.length != 2) {
            System.out.println("Invalid arguments!");
            System.out.println("Usage: DemoClient host port");
            System.exit(-1);
        }
        port = Integer.parseInt(args[1]);
        host = args[0];
        DemoClient client = new DemoClient();
        client.run();
    }

    DemoClient() {
    }

    private String utf8(byte[] buf) {
        try {
            return this.decoder.decode(ByteBuffer.wrap(buf)).toString();
        }
        catch (CharacterCodingException e) {
            return "[INVALID UTF-8]";
        }
    }

    private byte[] bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void run() throws IOError, TException, IllegalArgument, AlreadyExists {
        List entry;
        TSocket transport = new TSocket(host, port);
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport, true, true);
        Hbase.Client client = new Hbase.Client((TProtocol)protocol);
        transport.open();
        byte[] t = this.bytes("demo_table");
        System.out.println("scanning tables...");
        for (ByteBuffer name : client.getTableNames()) {
            System.out.println("  found: " + this.utf8(name.array()));
            if (!this.utf8(name.array()).equals(this.utf8(t))) continue;
            if (client.isTableEnabled(name)) {
                System.out.println("    disabling table: " + this.utf8(name.array()));
                client.disableTable(name);
            }
            System.out.println("    deleting table: " + this.utf8(name.array()));
            client.deleteTable(name);
        }
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>();
        ColumnDescriptor col = new ColumnDescriptor();
        col.name = ByteBuffer.wrap(this.bytes("entry:"));
        col.maxVersions = 10;
        columns.add(col);
        col = new ColumnDescriptor();
        col.name = ByteBuffer.wrap(this.bytes("unused:"));
        columns.add(col);
        System.out.println("creating table: " + this.utf8(t));
        try {
            client.createTable(ByteBuffer.wrap(t), columns);
        }
        catch (AlreadyExists ae) {
            System.out.println("WARN: " + ae.message);
        }
        System.out.println("column families in " + this.utf8(t) + ": ");
        Map columnMap = client.getColumnDescriptors(ByteBuffer.wrap(t));
        for (ColumnDescriptor col2 : columnMap.values()) {
            System.out.println("  column: " + this.utf8(col2.name.array()) + ", maxVer: " + Integer.toString(col2.maxVersions));
        }
        Map dummyAttributes = null;
        boolean writeToWal = false;
        byte[] invalid = new byte[]{102, 111, 111, 45, -4, -95, -95, -95, -95};
        byte[] valid = new byte[]{102, 111, 111, 45, -25, -108, -97, -29, -125, -109, -29, -125, -68, -29, -125, -85};
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:foo")), ByteBuffer.wrap(invalid), writeToWal));
        client.mutateRow(ByteBuffer.wrap(t), ByteBuffer.wrap(this.bytes("foo")), mutations, dummyAttributes);
        mutations = new ArrayList();
        mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:foo")), ByteBuffer.wrap(valid), writeToWal));
        client.mutateRow(ByteBuffer.wrap(t), ByteBuffer.wrap(valid), mutations, dummyAttributes);
        mutations = new ArrayList();
        mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:foo")), ByteBuffer.wrap(invalid), writeToWal));
        client.mutateRow(ByteBuffer.wrap(t), ByteBuffer.wrap(invalid), mutations, dummyAttributes);
        ArrayList<ByteBuffer> columnNames = new ArrayList<ByteBuffer>();
        columnNames.add(ByteBuffer.wrap(this.bytes("entry:")));
        System.out.println("Starting scanner...");
        int scanner = client.scannerOpen(ByteBuffer.wrap(t), ByteBuffer.wrap(this.bytes("")), columnNames, dummyAttributes);
        while (!(entry = client.scannerGet(scanner)).isEmpty()) {
            this.printRow(entry);
        }
        for (int i = 100; i >= 0; --i) {
            List result;
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMinimumIntegerDigits(5);
            nf.setGroupingUsed(false);
            byte[] row = this.bytes(nf.format(i));
            mutations = new ArrayList();
            mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("unused:")), ByteBuffer.wrap(this.bytes("DELETE_ME")), writeToWal));
            client.mutateRow(ByteBuffer.wrap(t), ByteBuffer.wrap(row), mutations, dummyAttributes);
            this.printRow(client.getRow(ByteBuffer.wrap(t), ByteBuffer.wrap(row), dummyAttributes));
            client.deleteAllRow(ByteBuffer.wrap(t), ByteBuffer.wrap(row), dummyAttributes);
            mutations = new ArrayList();
            mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:num")), ByteBuffer.wrap(this.bytes("0")), writeToWal));
            mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:foo")), ByteBuffer.wrap(this.bytes("FOO")), writeToWal));
            client.mutateRow(ByteBuffer.wrap(t), ByteBuffer.wrap(row), mutations, dummyAttributes);
            this.printRow(client.getRow(ByteBuffer.wrap(t), ByteBuffer.wrap(row), dummyAttributes));
            mutations = new ArrayList();
            Mutation m = new Mutation();
            m.column = ByteBuffer.wrap(this.bytes("entry:foo"));
            m.isDelete = true;
            mutations.add(m);
            m = new Mutation();
            m.column = ByteBuffer.wrap(this.bytes("entry:num"));
            m.value = ByteBuffer.wrap(this.bytes("-1"));
            mutations.add(m);
            client.mutateRow(ByteBuffer.wrap(t), ByteBuffer.wrap(row), mutations, dummyAttributes);
            this.printRow(client.getRow(ByteBuffer.wrap(t), ByteBuffer.wrap(row), dummyAttributes));
            mutations = new ArrayList();
            mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:num")), ByteBuffer.wrap(this.bytes(Integer.toString(i))), writeToWal));
            mutations.add(new Mutation(false, ByteBuffer.wrap(this.bytes("entry:sqr")), ByteBuffer.wrap(this.bytes(Integer.toString(i * i))), writeToWal));
            client.mutateRow(ByteBuffer.wrap(t), ByteBuffer.wrap(row), mutations, dummyAttributes);
            this.printRow(client.getRow(ByteBuffer.wrap(t), ByteBuffer.wrap(row), dummyAttributes));
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            mutations.clear();
            m = new Mutation();
            m.column = ByteBuffer.wrap(this.bytes("entry:num"));
            m.value = ByteBuffer.wrap(this.bytes("-999"));
            mutations.add(m);
            m = new Mutation();
            m.column = ByteBuffer.wrap(this.bytes("entry:sqr"));
            m.isDelete = true;
            client.mutateRowTs(ByteBuffer.wrap(t), ByteBuffer.wrap(row), mutations, 1L, dummyAttributes);
            this.printRow(client.getRow(ByteBuffer.wrap(t), ByteBuffer.wrap(row), dummyAttributes));
            List versions = client.getVer(ByteBuffer.wrap(t), ByteBuffer.wrap(row), ByteBuffer.wrap(this.bytes("entry:num")), 10, dummyAttributes);
            this.printVersions(ByteBuffer.wrap(row), versions);
            if (versions.isEmpty()) {
                System.out.println("FATAL: wrong # of versions");
                System.exit(-1);
            }
            if (!(result = client.get(ByteBuffer.wrap(t), ByteBuffer.wrap(row), ByteBuffer.wrap(this.bytes("entry:foo")), dummyAttributes)).isEmpty()) {
                System.out.println("FATAL: shouldn't get here");
                System.exit(-1);
            }
            System.out.println("");
        }
        columnNames.clear();
        for (ColumnDescriptor col2 : client.getColumnDescriptors(ByteBuffer.wrap(t)).values()) {
            System.out.println("column with name: " + new String(col2.name.array()));
            System.out.println(col2.toString());
            columnNames.add(col2.name);
        }
        System.out.println("Starting scanner...");
        scanner = client.scannerOpenWithStop(ByteBuffer.wrap(t), ByteBuffer.wrap(this.bytes("00020")), ByteBuffer.wrap(this.bytes("00040")), columnNames, dummyAttributes);
        while (true) {
            if ((entry = client.scannerGet(scanner)).isEmpty()) break;
            this.printRow(entry);
        }
        System.out.println("Scanner finished");
        transport.close();
    }

    private void printVersions(ByteBuffer row, List<TCell> versions) {
        StringBuilder rowStr = new StringBuilder();
        for (TCell cell : versions) {
            rowStr.append(this.utf8(cell.value.array()));
            rowStr.append("; ");
        }
        System.out.println("row: " + this.utf8(row.array()) + ", values: " + rowStr);
    }

    private void printRow(TRowResult rowResult) {
        TreeMap sorted = new TreeMap();
        for (Map.Entry column : rowResult.columns.entrySet()) {
            sorted.put(this.utf8(((ByteBuffer)column.getKey()).array()), column.getValue());
        }
        StringBuilder rowStr = new StringBuilder();
        for (Map.Entry entry : sorted.entrySet()) {
            rowStr.append((String)entry.getKey());
            rowStr.append(" => ");
            rowStr.append(this.utf8(((TCell)entry.getValue()).value.array()));
            rowStr.append("; ");
        }
        System.out.println("row: " + this.utf8(rowResult.row.array()) + ", cols: " + rowStr);
    }

    private void printRow(List<TRowResult> rows) {
        for (TRowResult rowResult : rows) {
            this.printRow(rowResult);
        }
    }
}

