/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

public class ZooKeeperScanPolicyObserver
extends BaseRegionObserver {
    public static final String node = "/backup/example/lastbackup";
    public static final String zkkey = "ZK";
    private static final Log LOG = LogFactory.getLog(ZooKeeperScanPolicyObserver.class);

    public void start(CoprocessorEnvironment e) throws IOException {
        RegionCoprocessorEnvironment re = (RegionCoprocessorEnvironment)e;
        if (!re.getSharedData().containsKey(zkkey)) {
            re.getSharedData().putIfAbsent(zkkey, new ZKWatcher(re.getRegionServerServices().getZooKeeper().getRecoverableZooKeeper().getZooKeeper()));
        }
    }

    public void stop(CoprocessorEnvironment e) throws IOException {
    }

    protected ScanInfo getScanInfo(Store store, RegionCoprocessorEnvironment e) {
        byte[] data = ((ZKWatcher)e.getSharedData().get(zkkey)).getData();
        if (data == null) {
            return null;
        }
        ScanInfo oldSI = store.getScanInfo();
        if (oldSI.getTtl() == Long.MAX_VALUE) {
            return null;
        }
        long ttl = Math.max(EnvironmentEdgeManager.currentTimeMillis() - Bytes.toLong((byte[])data), oldSI.getTtl());
        return new ScanInfo(store.getFamily(), ttl, oldSI.getTimeToPurgeDeletes(), oldSI.getComparator());
    }

    public InternalScanner preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, KeyValueScanner memstoreScanner, InternalScanner s) throws IOException {
        ScanInfo scanInfo = this.getScanInfo(store, (RegionCoprocessorEnvironment)c.getEnvironment());
        if (scanInfo == null) {
            return null;
        }
        Scan scan = new Scan();
        scan.setMaxVersions(scanInfo.getMaxVersions());
        return new StoreScanner(store, scanInfo, scan, Collections.singletonList(memstoreScanner), ScanType.COMPACT_RETAIN_DELETES, store.getSmallestReadPoint(), Long.MIN_VALUE);
    }

    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s) throws IOException {
        ScanInfo scanInfo = this.getScanInfo(store, (RegionCoprocessorEnvironment)c.getEnvironment());
        if (scanInfo == null) {
            return null;
        }
        Scan scan = new Scan();
        scan.setMaxVersions(scanInfo.getMaxVersions());
        return new StoreScanner(store, scanInfo, scan, scanners, scanType, store.getSmallestReadPoint(), earliestPutTs);
    }

    public KeyValueScanner preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, Scan scan, NavigableSet<byte[]> targetCols, KeyValueScanner s) throws IOException {
        ScanInfo scanInfo = this.getScanInfo(store, (RegionCoprocessorEnvironment)c.getEnvironment());
        if (scanInfo == null) {
            return null;
        }
        return new StoreScanner(store, scanInfo, scan, targetCols);
    }

    private static class ZKWatcher
    implements Watcher {
        private byte[] data = null;
        private ZooKeeper zk;
        private volatile boolean needSetup = true;
        private volatile long lastSetupTry = 0L;

        public ZKWatcher(ZooKeeper zk) {
            this.zk = zk;
            this.getData();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressWarnings(value={"REC_CATCH_EXCEPTION"})
        public byte[] getData() {
            if (this.needSetup && EnvironmentEdgeManager.currentTimeMillis() > this.lastSetupTry + 30000L) {
                ZKWatcher zKWatcher = this;
                synchronized (zKWatcher) {
                    if (!this.needSetup) {
                        return this.data;
                    }
                    this.needSetup = false;
                }
                try {
                    LOG.debug((Object)"Connecting to ZK");
                    this.lastSetupTry = EnvironmentEdgeManager.currentTimeMillis();
                    if (this.zk.exists(ZooKeeperScanPolicyObserver.node, false) != null) {
                        this.data = this.zk.getData(ZooKeeperScanPolicyObserver.node, (Watcher)this, null);
                        LOG.debug((Object)("Read synchronously: " + (this.data == null ? "null" : Long.valueOf(Bytes.toLong((byte[])this.data)))));
                    } else {
                        this.zk.exists(ZooKeeperScanPolicyObserver.node, (Watcher)this);
                    }
                }
                catch (Exception x) {
                    this.needSetup = true;
                }
            }
            return this.data;
        }

        public void process(WatchedEvent event) {
            switch (event.getType()) {
                case NodeDataChanged: 
                case NodeCreated: {
                    try {
                        this.data = this.zk.getData(ZooKeeperScanPolicyObserver.node, (Watcher)this, null);
                        LOG.debug((Object)("Read asynchronously: " + (this.data == null ? "null" : Long.valueOf(Bytes.toLong((byte[])this.data)))));
                    }
                    catch (InterruptedException ix) {
                    }
                    catch (KeeperException kx) {
                        this.needSetup = true;
                    }
                    break;
                }
                case NodeDeleted: {
                    try {
                        this.zk.exists(ZooKeeperScanPolicyObserver.node, (Watcher)this);
                        this.data = null;
                    }
                    catch (InterruptedException ix) {
                    }
                    catch (KeeperException kx) {
                        this.needSetup = true;
                    }
                    break;
                }
            }
        }
    }
}

