/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.PingProtos;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestServerCustomProtocol {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestServerCustomProtocol.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestServerCustomProtocol.class);
    static final String WHOAREYOU = "Who are you?";
    static final String NOBODY = "nobody";
    static final String HELLO = "Hello, ";
    private static final TableName TEST_TABLE = TableName.valueOf((String)"test");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f1");
    private static final byte[] ROW_A = Bytes.toBytes((String)"aaa");
    private static final byte[] ROW_B = Bytes.toBytes((String)"bbb");
    private static final byte[] ROW_C = Bytes.toBytes((String)"ccc");
    private static final byte[] ROW_AB = Bytes.toBytes((String)"abb");
    private static final byte[] ROW_BC = Bytes.toBytes((String)"bcc");
    private static HBaseTestingUtility util = new HBaseTestingUtility();

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        util.getConfiguration().set("hbase.coprocessor.region.classes", PingHandler.class.getName());
        util.startMiniCluster();
    }

    @Before
    public void before() throws Exception {
        byte[][] SPLIT_KEYS = new byte[][]{ROW_B, ROW_C};
        Table table = util.createTable(TEST_TABLE, TEST_FAMILY, (byte[][])SPLIT_KEYS);
        Put puta = new Put(ROW_A);
        puta.addColumn(TEST_FAMILY, Bytes.toBytes((String)"col1"), Bytes.toBytes((int)1));
        table.put(puta);
        Put putb = new Put(ROW_B);
        putb.addColumn(TEST_FAMILY, Bytes.toBytes((String)"col1"), Bytes.toBytes((int)1));
        table.put(putb);
        Put putc = new Put(ROW_C);
        putc.addColumn(TEST_FAMILY, Bytes.toBytes((String)"col1"), Bytes.toBytes((int)1));
        table.put(putc);
    }

    @After
    public void after() throws Exception {
        util.deleteTable(TEST_TABLE);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testSingleProxy() throws Throwable {
        Table table = util.getConnection().getTable(TEST_TABLE);
        Map<byte[], String> results = this.ping(table, null, null);
        Assert.assertEquals((long)3L, (long)results.size());
        for (Map.Entry<byte[], String> e : results.entrySet()) {
            Assert.assertEquals((String)"Invalid custom protocol response", (Object)"pong", (Object)e.getValue());
        }
        this.hello(table, "George", "Hello, George");
        LOG.info("Did george");
        this.hello(table, null, WHOAREYOU);
        LOG.info("Who are you");
        this.hello(table, NOBODY, null);
        LOG.info(NOBODY);
        Map intResults = table.coprocessorService(PingProtos.PingService.class, null, null, (Batch.Call)new Batch.Call<PingProtos.PingService, Integer>(){

            public Integer call(PingProtos.PingService instance) throws IOException {
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                instance.count(null, PingProtos.CountRequest.newBuilder().build(), (RpcCallback)rpcCallback);
                return ((PingProtos.CountResponse)rpcCallback.get()).getCount();
            }
        });
        int count = -1;
        for (Map.Entry e : intResults.entrySet()) {
            Assert.assertTrue(((Integer)e.getValue() > 0 ? 1 : 0) != 0);
            count = (Integer)e.getValue();
        }
        int diff = 5;
        intResults = table.coprocessorService(PingProtos.PingService.class, null, null, (Batch.Call)new Batch.Call<PingProtos.PingService, Integer>(){

            public Integer call(PingProtos.PingService instance) throws IOException {
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                instance.increment(null, PingProtos.IncrementCountRequest.newBuilder().setDiff(5).build(), (RpcCallback)rpcCallback);
                return ((PingProtos.IncrementCountResponse)rpcCallback.get()).getCount();
            }
        });
        Assert.assertEquals((long)3L, (long)results.size());
        for (Map.Entry e : intResults.entrySet()) {
            Assert.assertEquals((long)((Integer)e.getValue()).intValue(), (long)(count + 5));
        }
        table.close();
    }

    private Map<byte[], String> hello(Table table, String send, String response) throws ServiceException, Throwable {
        Map<byte[], String> results = this.hello(table, send);
        for (Map.Entry<byte[], String> e : results.entrySet()) {
            Assert.assertEquals((String)"Invalid custom protocol response", (Object)response, (Object)e.getValue());
        }
        return results;
    }

    private Map<byte[], String> hello(Table table, String send) throws ServiceException, Throwable {
        return this.hello(table, send, null, null);
    }

    private Map<byte[], String> hello(Table table, final String send, byte[] start, byte[] end) throws ServiceException, Throwable {
        return table.coprocessorService(PingProtos.PingService.class, start, end, (Batch.Call)new Batch.Call<PingProtos.PingService, String>(){

            public String call(PingProtos.PingService instance) throws IOException {
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                PingProtos.HelloRequest.Builder builder = PingProtos.HelloRequest.newBuilder();
                if (send != null) {
                    builder.setName(send);
                }
                instance.hello(null, builder.build(), (RpcCallback)rpcCallback);
                PingProtos.HelloResponse r = (PingProtos.HelloResponse)rpcCallback.get();
                return r != null && r.hasResponse() ? r.getResponse() : null;
            }
        });
    }

    private Map<byte[], String> compoundOfHelloAndPing(Table table, byte[] start, byte[] end) throws ServiceException, Throwable {
        return table.coprocessorService(PingProtos.PingService.class, start, end, (Batch.Call)new Batch.Call<PingProtos.PingService, String>(){

            public String call(PingProtos.PingService instance) throws IOException {
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                PingProtos.HelloRequest.Builder builder = PingProtos.HelloRequest.newBuilder();
                builder.setName(TestServerCustomProtocol.doPing(instance));
                instance.hello(null, builder.build(), (RpcCallback)rpcCallback);
                PingProtos.HelloResponse r = (PingProtos.HelloResponse)rpcCallback.get();
                return r != null && r.hasResponse() ? r.getResponse() : null;
            }
        });
    }

    private Map<byte[], String> noop(Table table, byte[] start, byte[] end) throws ServiceException, Throwable {
        return table.coprocessorService(PingProtos.PingService.class, start, end, (Batch.Call)new Batch.Call<PingProtos.PingService, String>(){

            public String call(PingProtos.PingService instance) throws IOException {
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                PingProtos.NoopRequest.Builder builder = PingProtos.NoopRequest.newBuilder();
                instance.noop(null, builder.build(), (RpcCallback)rpcCallback);
                rpcCallback.get();
                return null;
            }
        });
    }

    @Test
    public void testSingleMethod() throws Throwable {
        try (Table table = util.getConnection().getTable(TEST_TABLE);
             RegionLocator locator = util.getConnection().getRegionLocator(TEST_TABLE);){
            Map<byte[], String> results = table.coprocessorService(PingProtos.PingService.class, null, ROW_A, (Batch.Call)new Batch.Call<PingProtos.PingService, String>(){

                public String call(PingProtos.PingService instance) throws IOException {
                    CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                    instance.ping(null, PingProtos.PingRequest.newBuilder().build(), (RpcCallback)rpcCallback);
                    return ((PingProtos.PingResponse)rpcCallback.get()).getPong();
                }
            });
            Assert.assertEquals((long)1L, (long)results.size());
            this.verifyRegionResults(locator, results, ROW_A);
            String name = "NAME";
            results = this.hello(table, "NAME", null, ROW_A);
            Assert.assertEquals((long)1L, (long)results.size());
            this.verifyRegionResults(locator, results, "Hello, NAME", ROW_A);
        }
    }

    @Test
    public void testRowRange() throws Throwable {
        try (Table table = util.getConnection().getTable(TEST_TABLE);
             RegionLocator locator = util.getConnection().getRegionLocator(TEST_TABLE);){
            for (HRegionLocation e : locator.getAllRegionLocations()) {
                LOG.info("Region " + e.getRegionInfo().getRegionNameAsString() + ", servername=" + e.getServerName());
            }
            Map<byte[], String> results = this.ping(table, null, ROW_A);
            Assert.assertEquals((long)1L, (long)results.size());
            this.verifyRegionResults(locator, results, ROW_A);
            results = this.ping(table, ROW_BC, null);
            Assert.assertEquals((long)2L, (long)results.size());
            HRegionLocation loc = locator.getRegionLocation(ROW_A, true);
            Assert.assertNull((String)"Should be missing region for row aaa (prior to start row)", (Object)results.get(loc.getRegionInfo().getRegionName()));
            this.verifyRegionResults(locator, results, ROW_B);
            this.verifyRegionResults(locator, results, ROW_C);
            results = this.ping(table, null, ROW_BC);
            Assert.assertEquals((long)2L, (long)results.size());
            this.verifyRegionResults(locator, results, ROW_A);
            this.verifyRegionResults(locator, results, ROW_B);
            loc = locator.getRegionLocation(ROW_C, true);
            Assert.assertNull((String)"Should be missing region for row ccc (past stop row)", (Object)results.get(loc.getRegionInfo().getRegionName()));
            results = this.ping(table, ROW_AB, ROW_BC);
            Assert.assertEquals((long)2L, (long)results.size());
            this.verifyRegionResults(locator, results, ROW_A);
            this.verifyRegionResults(locator, results, ROW_B);
            loc = locator.getRegionLocation(ROW_C, true);
            Assert.assertNull((String)"Should be missing region for row ccc (past stop row)", (Object)results.get(loc.getRegionInfo().getRegionName()));
            results = this.ping(table, ROW_B, ROW_BC);
            Assert.assertEquals((long)1L, (long)results.size());
            this.verifyRegionResults(locator, results, ROW_B);
            loc = locator.getRegionLocation(ROW_A, true);
            Assert.assertNull((String)"Should be missing region for row aaa (prior to start)", (Object)results.get(loc.getRegionInfo().getRegionName()));
            loc = locator.getRegionLocation(ROW_C, true);
            Assert.assertNull((String)"Should be missing region for row ccc (past stop row)", (Object)results.get(loc.getRegionInfo().getRegionName()));
        }
    }

    private Map<byte[], String> ping(Table table, byte[] start, byte[] end) throws ServiceException, Throwable {
        return table.coprocessorService(PingProtos.PingService.class, start, end, (Batch.Call)new Batch.Call<PingProtos.PingService, String>(){

            public String call(PingProtos.PingService instance) throws IOException {
                return TestServerCustomProtocol.doPing(instance);
            }
        });
    }

    private static String doPing(PingProtos.PingService instance) throws IOException {
        CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
        instance.ping(null, PingProtos.PingRequest.newBuilder().build(), (RpcCallback)rpcCallback);
        return ((PingProtos.PingResponse)rpcCallback.get()).getPong();
    }

    @Test
    public void testCompoundCall() throws Throwable {
        try (Table table = util.getConnection().getTable(TEST_TABLE);
             RegionLocator locator = util.getConnection().getRegionLocator(TEST_TABLE);){
            Map<byte[], String> results = this.compoundOfHelloAndPing(table, ROW_A, ROW_C);
            this.verifyRegionResults(locator, results, "Hello, pong", ROW_A);
            this.verifyRegionResults(locator, results, "Hello, pong", ROW_B);
            this.verifyRegionResults(locator, results, "Hello, pong", ROW_C);
        }
    }

    @Test
    public void testNullCall() throws Throwable {
        try (Table table = util.getConnection().getTable(TEST_TABLE);
             RegionLocator locator = util.getConnection().getRegionLocator(TEST_TABLE);){
            Map<byte[], String> results = this.hello(table, null, ROW_A, ROW_C);
            this.verifyRegionResults(locator, results, WHOAREYOU, ROW_A);
            this.verifyRegionResults(locator, results, WHOAREYOU, ROW_B);
            this.verifyRegionResults(locator, results, WHOAREYOU, ROW_C);
        }
    }

    @Test
    public void testNullReturn() throws Throwable {
        try (Table table = util.getConnection().getTable(TEST_TABLE);
             RegionLocator locator = util.getConnection().getRegionLocator(TEST_TABLE);){
            Map<byte[], String> results = this.hello(table, NOBODY, ROW_A, ROW_C);
            this.verifyRegionResults(locator, results, null, ROW_A);
            this.verifyRegionResults(locator, results, null, ROW_B);
            this.verifyRegionResults(locator, results, null, ROW_C);
        }
    }

    @Test
    public void testEmptyReturnType() throws Throwable {
        try (Table table = util.getConnection().getTable(TEST_TABLE);){
            Map<byte[], String> results = this.noop(table, ROW_A, ROW_C);
            Assert.assertEquals((String)"Should have results from three regions", (long)3L, (long)results.size());
            for (String v : results.values()) {
                Assert.assertNull((Object)v);
            }
        }
    }

    private void verifyRegionResults(RegionLocator table, Map<byte[], String> results, byte[] row) throws Exception {
        this.verifyRegionResults(table, results, "pong", row);
    }

    private void verifyRegionResults(RegionLocator regionLocator, Map<byte[], String> results, String expected, byte[] row) throws Exception {
        for (Map.Entry<byte[], String> e : results.entrySet()) {
            LOG.info("row=" + Bytes.toString((byte[])row) + ", expected=" + expected + ", result key=" + Bytes.toString((byte[])e.getKey()) + ", value=" + e.getValue());
        }
        HRegionLocation loc = regionLocator.getRegionLocation(row, true);
        byte[] region = loc.getRegionInfo().getRegionName();
        Assert.assertTrue((String)("Results should contain region " + Bytes.toStringBinary((byte[])region) + " for row '" + Bytes.toStringBinary((byte[])row) + "'"), (boolean)results.containsKey(region));
        Assert.assertEquals((String)("Invalid result for row '" + Bytes.toStringBinary((byte[])row) + "'"), (Object)expected, (Object)results.get(region));
    }

    public static class PingHandler
    extends PingProtos.PingService
    implements RegionCoprocessor {
        private int counter = 0;

        public void start(CoprocessorEnvironment env) throws IOException {
            if (env instanceof RegionCoprocessorEnvironment) {
                return;
            }
            throw new CoprocessorException("Must be loaded on a table region!");
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
        }

        public void ping(RpcController controller, PingProtos.PingRequest request, RpcCallback<PingProtos.PingResponse> done) {
            ++this.counter;
            done.run((Object)PingProtos.PingResponse.newBuilder().setPong("pong").build());
        }

        public void count(RpcController controller, PingProtos.CountRequest request, RpcCallback<PingProtos.CountResponse> done) {
            done.run((Object)PingProtos.CountResponse.newBuilder().setCount(this.counter).build());
        }

        public void increment(RpcController controller, PingProtos.IncrementCountRequest request, RpcCallback<PingProtos.IncrementCountResponse> done) {
            this.counter += request.getDiff();
            done.run((Object)PingProtos.IncrementCountResponse.newBuilder().setCount(this.counter).build());
        }

        public void hello(RpcController controller, PingProtos.HelloRequest request, RpcCallback<PingProtos.HelloResponse> done) {
            if (!request.hasName()) {
                done.run((Object)PingProtos.HelloResponse.newBuilder().setResponse(TestServerCustomProtocol.WHOAREYOU).build());
            } else if (request.getName().equals(TestServerCustomProtocol.NOBODY)) {
                done.run((Object)PingProtos.HelloResponse.newBuilder().build());
            } else {
                done.run((Object)PingProtos.HelloResponse.newBuilder().setResponse(TestServerCustomProtocol.HELLO + request.getName()).build());
            }
        }

        public void noop(RpcController controller, PingProtos.NoopRequest request, RpcCallback<PingProtos.NoopResponse> done) {
            done.run((Object)PingProtos.NoopResponse.newBuilder().build());
        }

        public Iterable<Service> getServices() {
            return Collections.singleton(this);
        }
    }
}

