/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.coprocessor;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.AggregationClient;
import org.apache.hadoop.hbase.client.coprocessor.LongColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.AggregateImplementation;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, CoprocessorTests.class})
public class TestAggregationClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAggregationClient.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestAggregationClient");
    private static final byte[] CF = Bytes.toBytes((String)"CF");
    private static Connection CONN;
    private static Table TABLE;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{AggregateImplementation.class.getName()});
        UTIL.startMiniCluster(1);
        UTIL.createTable(TABLE_NAME, CF);
        CONN = ConnectionFactory.createConnection((Configuration)conf);
        TABLE = CONN.getTable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CONN.close();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void itCreatesConnectionless() throws Throwable {
        AggregationClient client = new AggregationClient();
        Assert.assertFalse((boolean)client.isClosed());
        try {
            client.rowCount(TABLE_NAME, (ColumnInterpreter)new LongColumnInterpreter(), new Scan());
            Assert.fail((String)"Expected IOException");
        }
        catch (Throwable e) {
            Assert.assertTrue((boolean)(e instanceof IOException));
            Assert.assertTrue((boolean)e.getMessage().contains("Connection not initialized"));
        }
        client.rowCount(TABLE, (ColumnInterpreter)new LongColumnInterpreter(), new Scan());
        client.close();
        Assert.assertFalse((boolean)CONN.isClosed());
        Assert.assertFalse((boolean)client.isClosed());
    }

    @Test
    public void itCreatesExternalConnection() throws Throwable {
        AggregationClient client = new AggregationClient(CONN);
        Assert.assertFalse((boolean)client.isClosed());
        client.rowCount(TABLE_NAME, (ColumnInterpreter)new LongColumnInterpreter(), new Scan());
        client.rowCount(TABLE, (ColumnInterpreter)new LongColumnInterpreter(), new Scan());
        client.close();
        Assert.assertFalse((boolean)CONN.isClosed());
        Assert.assertFalse((boolean)client.isClosed());
    }

    @Test
    public void itCreatesManagedConnection() throws Throwable {
        AggregationClient client = new AggregationClient(CONN.getConfiguration());
        Assert.assertFalse((boolean)client.isClosed());
        client.rowCount(TABLE_NAME, (ColumnInterpreter)new LongColumnInterpreter(), new Scan());
        client.rowCount(TABLE, (ColumnInterpreter)new LongColumnInterpreter(), new Scan());
        client.close();
        Assert.assertFalse((boolean)CONN.isClosed());
        Assert.assertTrue((boolean)client.isClosed());
    }
}

