/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScannable;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ProtobufCoprocessorService;
import org.apache.hadoop.hbase.ipc.DelegatingHBaseRpcController;
import org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.ConcurrentHashMultiset;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Multiset;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class, ClientTests.class})
public class TestRpcControllerFactory {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRpcControllerFactory.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setup() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.region.classes", ProtobufCoprocessorService.class.getName());
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCountController() throws Exception {
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.set("hbase.rpc.controllerfactory.class", StaticRpcControllerFactory.class.getName());
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        UTIL.createTable(tableName, HBaseTestingUtility.fam1).close();
        conf.setInt("hbase.rpc.timeout", 60001);
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Table table = connection.getTable(tableName);
        byte[] row = Bytes.toBytes((String)"row");
        Put p = new Put(row);
        p.addColumn(HBaseTestingUtility.fam1, HBaseTestingUtility.fam1, Bytes.toBytes((String)"val0"));
        table.put(p);
        Integer counter = 1;
        counter = this.verifyCount(counter);
        Delete d = new Delete(row);
        d.addColumn(HBaseTestingUtility.fam1, HBaseTestingUtility.fam1);
        table.delete(d);
        counter = this.verifyCount(counter);
        Put p2 = new Put(row);
        p2.addColumn(HBaseTestingUtility.fam1, Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"val1"));
        table.batch((List)Lists.newArrayList((Object[])new Put[]{p, p2}), null);
        counter = this.verifyCount(counter);
        Append append = new Append(row);
        append.addColumn(HBaseTestingUtility.fam1, HBaseTestingUtility.fam1, Bytes.toBytes((String)"val2"));
        table.append(append);
        counter = this.verifyCount(counter);
        Get g = new Get(row);
        table.get(g);
        counter = this.verifyCount(counter);
        ResultScanner scan = table.getScanner(HBaseTestingUtility.fam1);
        scan.next();
        scan.close();
        counter = this.verifyCount(counter + 1);
        Get g2 = new Get(row);
        table.get((List)Lists.newArrayList((Object[])new Get[]{g, g2}));
        counter = this.verifyCount(counter);
        Scan scanInfo = new Scan(row);
        scanInfo.setSmall(true);
        counter = this.doScan(table, scanInfo, counter);
        scanInfo.setReversed(true);
        counter = this.doScan(table, scanInfo, counter);
        scanInfo.setSmall(false);
        counter = this.doScan(table, scanInfo, counter + 1);
        this.verifyPriorityGroupCount(100, 0);
        Get get = new Get(row);
        get.setPriority(100);
        table.get(get);
        this.verifyPriorityGroupCount(100, 1);
        table.close();
        connection.close();
    }

    int doScan(Table table, Scan scan, int expectedCount) throws IOException {
        ResultScanner results = table.getScanner(scan);
        results.next();
        results.close();
        return this.verifyCount(expectedCount);
    }

    int verifyCount(Integer counter) {
        Assert.assertTrue((CountingRpcController.TABLE_PRIORITY.get() >= counter ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)CountingRpcController.INT_PRIORITY.get());
        return CountingRpcController.TABLE_PRIORITY.get() + 1;
    }

    void verifyPriorityGroupCount(int priorityLevel, int count) {
        Assert.assertEquals((long)count, (long)CountingRpcController.GROUPED_PRIORITY.count((Object)priorityLevel));
    }

    @Test
    public void testFallbackToDefaultRpcControllerFactory() {
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.set("hbase.rpc.controllerfactory.class", "foo.bar.Baz");
        RpcControllerFactory factory = RpcControllerFactory.instantiate((Configuration)conf);
        Assert.assertNotNull((Object)factory);
        Assert.assertEquals(factory.getClass(), RpcControllerFactory.class);
    }

    public static class CountingRpcController
    extends DelegatingHBaseRpcController {
        private static Multiset<Integer> GROUPED_PRIORITY = ConcurrentHashMultiset.create();
        private static AtomicInteger INT_PRIORITY = new AtomicInteger();
        private static AtomicInteger TABLE_PRIORITY = new AtomicInteger();

        public CountingRpcController(HBaseRpcController delegate) {
            super(delegate);
        }

        public void setPriority(int priority) {
            int oldPriority = this.getPriority();
            super.setPriority(priority);
            int newPriority = this.getPriority();
            if (newPriority != oldPriority) {
                INT_PRIORITY.incrementAndGet();
                GROUPED_PRIORITY.add((Object)priority);
            }
        }

        public void setPriority(TableName tn) {
            super.setPriority(tn);
            if (tn != null && !tn.isSystemTable()) {
                TABLE_PRIORITY.incrementAndGet();
            }
        }
    }

    public static class StaticRpcControllerFactory
    extends RpcControllerFactory {
        public StaticRpcControllerFactory(Configuration conf) {
            super(conf);
        }

        public HBaseRpcController newController() {
            return new CountingRpcController(super.newController());
        }

        public HBaseRpcController newController(RegionInfo regionInfo, CellScanner cellScanner) {
            return new CountingRpcController(super.newController(regionInfo, cellScanner));
        }

        public HBaseRpcController newController(RegionInfo regionInfo, List<CellScannable> cellIterables) {
            return new CountingRpcController(super.newController(regionInfo, cellIterables));
        }
    }
}

