/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.SingletonCoprocessorService;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.DummyRegionServerEndpointProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCoprocessorServiceBackwardCompatibility {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCoprocessorServiceBackwardCompatibility.class);
    private static HBaseTestingUtility TEST_UTIL = null;
    private static Configuration CONF = null;
    private static final long MASTER = 1L;
    private static final long REGIONSERVER = 2L;
    private static final long REGION = 3L;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        CONF = TEST_UTIL.getConfiguration();
        CONF.setStrings("hbase.coprocessor.master.classes", new String[]{DummyCoprocessorService.class.getName()});
        CONF.setStrings("hbase.coprocessor.regionserver.classes", new String[]{DummyCoprocessorService.class.getName()});
        CONF.setStrings("hbase.coprocessor.region.classes", new String[]{DummyCoprocessorService.class.getName()});
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfter() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testCoprocessorServiceLoadedByMaster() throws Throwable {
        TEST_UTIL.getAdmin().coprocessorService().callBlockingMethod(DummyCoprocessorService.getDescriptor().findMethodByName("dummyCall"), null, (Message)DummyRegionServerEndpointProtos.DummyRequest.newBuilder().setValue(1L).build(), (Message)DummyRegionServerEndpointProtos.DummyResponse.getDefaultInstance());
        Assert.assertEquals((long)1L, (long)DummyCoprocessorService.numMaster);
        TEST_UTIL.getAdmin().coprocessorService(TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName()).callBlockingMethod(DummyCoprocessorService.getDescriptor().findMethodByName("dummyCall"), null, (Message)DummyRegionServerEndpointProtos.DummyRequest.newBuilder().setValue(2L).build(), (Message)DummyRegionServerEndpointProtos.DummyResponse.getDefaultInstance());
        Assert.assertEquals((long)2L, (long)DummyCoprocessorService.numRegionServer);
        TEST_UTIL.getConnection().getTable(TableName.valueOf((String)"hbase:meta")).batchCoprocessorService(DummyCoprocessorService.getDescriptor().findMethodByName("dummyCall"), (Message)DummyRegionServerEndpointProtos.DummyRequest.newBuilder().setValue(3L).build(), Bytes.toBytes((String)""), Bytes.toBytes((String)""), (Message)DummyRegionServerEndpointProtos.DummyResponse.getDefaultInstance());
        Assert.assertEquals((long)3L, (long)DummyCoprocessorService.numRegion);
    }

    public static class DummyCoprocessorService
    extends DummyRegionServerEndpointProtos.DummyService
    implements CoprocessorService,
    SingletonCoprocessorService {
        static int numMaster = 0;
        static int numRegionServer = 0;
        static int numRegion = 0;

        public Service getService() {
            return this;
        }

        public void dummyCall(RpcController controller, DummyRegionServerEndpointProtos.DummyRequest request, RpcCallback<DummyRegionServerEndpointProtos.DummyResponse> callback) {
            callback.run((Object)DummyRegionServerEndpointProtos.DummyResponse.newBuilder().setValue("").build());
            if (request.getValue() == 1L) {
                numMaster = (int)((long)numMaster + request.getValue());
            } else if (request.getValue() == 2L) {
                numRegionServer = (int)((long)numRegionServer + request.getValue());
            } else if (request.getValue() == 3L) {
                numRegion = (int)((long)numRegion + request.getValue());
            }
        }

        public void dummyThrow(RpcController controller, DummyRegionServerEndpointProtos.DummyRequest request, RpcCallback<DummyRegionServerEndpointProtos.DummyResponse> callback) {
        }
    }
}

