/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.AsyncTable;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.AsyncAggregationClient;
import org.apache.hadoop.hbase.client.coprocessor.LongColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.AggregateImplementation;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, CoprocessorTests.class})
public class TestAsyncAggregationClient {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestAsyncAggregationClient.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_NAME = TableName.valueOf((String)"TestAsyncAggregationClient");
    private static byte[] CF = Bytes.toBytes((String)"CF");
    private static byte[] CQ = Bytes.toBytes((String)"CQ");
    private static byte[] CQ2 = Bytes.toBytes((String)"CQ2");
    private static int COUNT = 1000;
    private static AsyncConnection CONN;
    private static AsyncTable<AdvancedScanResultConsumer> TABLE;
    private static final double DELTA = 0.001;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{AggregateImplementation.class.getName()});
        UTIL.startMiniCluster(3);
        byte[][] splitKeys = new byte[8][];
        for (int i = 111; i < 999; i += 111) {
            splitKeys[i / 111 - 1] = Bytes.toBytes((String)String.format("%03d", i));
        }
        UTIL.createTable(TABLE_NAME, CF, (byte[][])splitKeys);
        CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UTIL.getConfiguration()).get();
        TABLE = CONN.getTable(TABLE_NAME);
        TABLE.putAll(LongStream.range(0L, COUNT).mapToObj(l -> new Put(Bytes.toBytes((String)String.format("%03d", l))).addColumn(CF, CQ, Bytes.toBytes((long)l)).addColumn(CF, CQ2, Bytes.toBytes((long)(l * l)))).collect(Collectors.toList())).get();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        CONN.close();
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMax() throws InterruptedException, ExecutionException {
        Assert.assertEquals((long)(COUNT - 1), (long)((Long)AsyncAggregationClient.max(TABLE, (ColumnInterpreter)new LongColumnInterpreter(), (Scan)new Scan().addColumn(CF, CQ)).get()));
    }

    @Test
    public void testMin() throws InterruptedException, ExecutionException {
        Assert.assertEquals((long)0L, (long)((Long)AsyncAggregationClient.min(TABLE, (ColumnInterpreter)new LongColumnInterpreter(), (Scan)new Scan().addColumn(CF, CQ)).get()));
    }

    @Test
    public void testRowCount() throws InterruptedException, ExecutionException {
        Assert.assertEquals((long)COUNT, (long)((Long)AsyncAggregationClient.rowCount(TABLE, (ColumnInterpreter)new LongColumnInterpreter(), (Scan)new Scan().addColumn(CF, CQ)).get()));
    }

    @Test
    public void testSum() throws InterruptedException, ExecutionException {
        Assert.assertEquals((long)(COUNT * (COUNT - 1) / 2), (long)((Long)AsyncAggregationClient.sum(TABLE, (ColumnInterpreter)new LongColumnInterpreter(), (Scan)new Scan().addColumn(CF, CQ)).get()));
    }

    @Test
    public void testAvg() throws InterruptedException, ExecutionException {
        Assert.assertEquals((double)((double)(COUNT - 1) / 2.0), (double)((Double)AsyncAggregationClient.avg(TABLE, (ColumnInterpreter)new LongColumnInterpreter(), (Scan)new Scan().addColumn(CF, CQ)).get()), (double)0.001);
    }

    @Test
    public void testStd() throws InterruptedException, ExecutionException {
        double avgSq = (double)LongStream.range(0L, COUNT).map(l -> l * l).reduce((l1, l2) -> l1 + l2).getAsLong() / (double)COUNT;
        double avg = (double)(COUNT - 1) / 2.0;
        double std = Math.sqrt(avgSq - avg * avg);
        Assert.assertEquals((double)std, (double)((Double)AsyncAggregationClient.std(TABLE, (ColumnInterpreter)new LongColumnInterpreter(), (Scan)new Scan().addColumn(CF, CQ)).get()), (double)0.001);
    }

    @Test
    public void testMedian() throws InterruptedException, ExecutionException {
        long halfSum = COUNT * (COUNT - 1) / 4;
        long median = 0L;
        long sum = 0L;
        for (int i = 0; i < COUNT; ++i) {
            if ((sum += (long)i) <= halfSum) continue;
            median = i - 1;
            break;
        }
        Assert.assertEquals((long)median, (long)((Long)AsyncAggregationClient.median(TABLE, (ColumnInterpreter)new LongColumnInterpreter(), (Scan)new Scan().addColumn(CF, CQ)).get()));
    }

    @Test
    public void testMedianWithWeight() throws InterruptedException, ExecutionException {
        long halfSum = LongStream.range(0L, COUNT).map(l -> l * l).reduce((l1, l2) -> l1 + l2).getAsLong() / 2L;
        long median = 0L;
        long sum = 0L;
        for (int i = 0; i < COUNT; ++i) {
            if ((sum += (long)(i * i)) <= halfSum) continue;
            median = i - 1;
            break;
        }
        Assert.assertEquals((long)median, (long)((Long)AsyncAggregationClient.median(TABLE, (ColumnInterpreter)new LongColumnInterpreter(), (Scan)new Scan().addColumn(CF, CQ).addColumn(CF, CQ2)).get()));
    }
}

