/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.ServiceException;
import java.io.File;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.Export;
import org.apache.hadoop.hbase.http.ssl.KeyStoreTestUtil;
import org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.HadoopSecurityEnabledUserProviderForTesting;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.access.AccessControlLists;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestSecureExport {
    private static final Log LOG = LogFactory.getLog(TestSecureExport.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static MiniKdc KDC;
    private static final File KEYTAB_FILE;
    private static String USERNAME;
    private static String SERVER_PRINCIPAL;
    private static String HTTP_PRINCIPAL;
    private static final String FAMILYA_STRING = "fma";
    private static final String FAMILYB_STRING = "fma";
    private static final byte[] FAMILYA;
    private static final byte[] FAMILYB;
    private static final byte[] ROW1;
    private static final byte[] ROW2;
    private static final byte[] ROW3;
    private static final byte[] QUAL;
    private static final String LOCALHOST = "localhost";
    private static final long NOW;
    private static final String USER_ADMIN = "admin";
    private static final String USER_OWNER = "owner";
    private static final String USER_RX = "rxuser";
    private static final String USER_XO = "xouser";
    private static final String USER_RO = "rouser";
    private static final String USER_NONE = "noneuser";
    private static final String PRIVATE = "private";
    private static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    private static final String TOPSECRET = "topsecret";
    @Rule
    public final TestName name = new TestName();

    private static void setUpKdcServer() throws Exception {
        Properties conf = MiniKdc.createConf();
        conf.put("debug", (Object)true);
        File kdcFile = new File(UTIL.getDataTestDir("kdc").toUri().getPath());
        KDC = new MiniKdc(conf, kdcFile);
        KDC.start();
        USERNAME = UserGroupInformation.getLoginUser().getShortUserName();
        SERVER_PRINCIPAL = USERNAME + "/" + LOCALHOST;
        HTTP_PRINCIPAL = "HTTP/localhost";
        KDC.createPrincipal(KEYTAB_FILE, new String[]{SERVER_PRINCIPAL, HTTP_PRINCIPAL, "admin/localhost", "owner/localhost", "rxuser/localhost", "rouser/localhost", "xouser/localhost", "noneuser/localhost"});
    }

    private static User getUserByLogin(String user) throws IOException {
        return User.create((UserGroupInformation)UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)TestSecureExport.getPrinciple(user), (String)KEYTAB_FILE.getAbsolutePath()));
    }

    private static String getPrinciple(String user) {
        return user + "/" + LOCALHOST + "@" + KDC.getRealm();
    }

    private static void setUpClusterKdc() throws Exception {
        HBaseKerberosUtils.setKeytabFileForTesting((String)KEYTAB_FILE.getAbsolutePath());
        HBaseKerberosUtils.setPrincipalForTesting((String)(SERVER_PRINCIPAL + "@" + KDC.getRealm()));
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)UTIL.getConfiguration());
        UTIL.getConfiguration().set("dfs.namenode.kerberos.principal", SERVER_PRINCIPAL + "@" + KDC.getRealm());
        UTIL.getConfiguration().set("dfs.datanode.kerberos.principal", SERVER_PRINCIPAL + "@" + KDC.getRealm());
        UTIL.getConfiguration().set("dfs.namenode.keytab.file", KEYTAB_FILE.getAbsolutePath());
        UTIL.getConfiguration().set("dfs.datanode.keytab.file", KEYTAB_FILE.getAbsolutePath());
        UTIL.getConfiguration().set("yarn.resourcemanager.principal", SERVER_PRINCIPAL + "@" + KDC.getRealm());
        UTIL.getConfiguration().set("yarn.nodemanager.principal", SERVER_PRINCIPAL + "@" + KDC.getRealm());
        UTIL.getConfiguration().set("dfs.web.authentication.kerberos.principal", HTTP_PRINCIPAL + "@" + KDC.getRealm());
        UTIL.getConfiguration().setBoolean("dfs.block.access.token.enable", true);
        UTIL.getConfiguration().set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        UTIL.getConfiguration().set("dfs.namenode.https-address", "localhost:0");
        UTIL.getConfiguration().set("dfs.datanode.https.address", "localhost:0");
        File keystoresDir = new File(UTIL.getDataTestDir("keystore").toUri().getPath());
        keystoresDir.mkdirs();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(TestSecureExport.class);
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir.getAbsolutePath(), (String)sslConfDir, (Configuration)UTIL.getConfiguration(), (boolean)false);
        UTIL.getConfiguration().setBoolean("ignore.secure.ports.for.testing", true);
        UserGroupInformation.setConfiguration((Configuration)UTIL.getConfiguration());
        UTIL.getConfiguration().set("hbase.coprocessor.region.classes", UTIL.getConfiguration().get("hbase.coprocessor.region.classes") + "," + Export.class.getName());
    }

    private static void addLabels(Configuration conf, List<String> users, List<String> labels) throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = () -> {
            try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                VisibilityClient.addLabels((Connection)conn, (String[])labels.toArray(new String[labels.size()]));
                for (String user : users) {
                    VisibilityClient.setAuths((Connection)conn, (String[])labels.toArray(new String[labels.size()]), (String)user);
                }
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
            return null;
        };
        TestSecureExport.getUserByLogin(USER_ADMIN).runAs(action);
    }

    @Before
    public void announce() {
        LOG.info((Object)("Running " + this.name.getMethodName()));
    }

    @After
    public void cleanup() throws IOException {
    }

    private static void clearOutput(Path path) throws IOException {
        FileSystem fs = path.getFileSystem(UTIL.getConfiguration());
        if (fs.exists(path)) {
            Assert.assertEquals((Object)true, (Object)fs.delete(path, true));
        }
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        UserProvider.setUserProviderForTesting((Configuration)UTIL.getConfiguration(), HadoopSecurityEnabledUserProviderForTesting.class);
        TestSecureExport.setUpKdcServer();
        SecureTestUtil.enableSecurity((Configuration)UTIL.getConfiguration());
        UTIL.getConfiguration().setBoolean("hbase.security.exec.permission.checks", true);
        VisibilityTestUtil.enableVisiblityLabels((Configuration)UTIL.getConfiguration());
        SecureTestUtil.verifyConfiguration((Configuration)UTIL.getConfiguration());
        TestSecureExport.setUpClusterKdc();
        UTIL.startMiniCluster();
        UTIL.waitUntilAllRegionsAssigned(AccessControlLists.ACL_TABLE_NAME);
        UTIL.waitUntilAllRegionsAssigned(VisibilityConstants.LABELS_TABLE_NAME);
        UTIL.waitTableEnabled(AccessControlLists.ACL_TABLE_NAME, 50000L);
        UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME, 50000L);
        SecureTestUtil.grantGlobal((HBaseTestingUtility)UTIL, (String)USER_ADMIN, (Permission.Action[])new Permission.Action[]{Permission.Action.ADMIN, Permission.Action.CREATE, Permission.Action.EXEC, Permission.Action.READ, Permission.Action.WRITE});
        TestSecureExport.addLabels(UTIL.getConfiguration(), Arrays.asList(USER_OWNER), Arrays.asList(PRIVATE, CONFIDENTIAL, SECRET, TOPSECRET));
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (KDC != null) {
            KDC.stop();
        }
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAccessCase() throws IOException, Throwable {
        String exportTable = this.name.getMethodName();
        TableDescriptor exportHtd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)this.name.getMethodName())).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILYA)).setOwnerString(USER_OWNER).build();
        SecureTestUtil.createTable((HBaseTestingUtility)UTIL, (TableDescriptor)exportHtd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        SecureTestUtil.grantOnTable((HBaseTestingUtility)UTIL, (String)USER_RO, (TableName)TableName.valueOf((String)exportTable), null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ});
        SecureTestUtil.grantOnTable((HBaseTestingUtility)UTIL, (String)USER_RX, (TableName)TableName.valueOf((String)exportTable), null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.READ, Permission.Action.EXEC});
        SecureTestUtil.grantOnTable((HBaseTestingUtility)UTIL, (String)USER_XO, (TableName)TableName.valueOf((String)exportTable), null, null, (Permission.Action[])new Permission.Action[]{Permission.Action.EXEC});
        Assert.assertEquals((long)4L, (long)AccessControlLists.getTablePermissions((Configuration)UTIL.getConfiguration(), (TableName)TableName.valueOf((String)exportTable)).size());
        SecureTestUtil.AccessTestAction putAction = () -> {
            Put p = new Put(ROW1);
            p.addColumn(FAMILYA, Bytes.toBytes((String)"qual_0"), NOW, QUAL);
            p.addColumn(FAMILYA, Bytes.toBytes((String)"qual_1"), NOW, QUAL);
            try (Connection conn = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
                 Table t = conn.getTable(TableName.valueOf((String)exportTable));){
                t.put(p);
            }
            return null;
        };
        SecureTestUtil.verifyAllowed((SecureTestUtil.AccessTestAction)putAction, (User[])new User[]{TestSecureExport.getUserByLogin(USER_ADMIN), TestSecureExport.getUserByLogin(USER_OWNER)});
        SecureTestUtil.verifyDenied((SecureTestUtil.AccessTestAction)putAction, (User[])new User[]{TestSecureExport.getUserByLogin(USER_RO), TestSecureExport.getUserByLogin(USER_XO), TestSecureExport.getUserByLogin(USER_RX), TestSecureExport.getUserByLogin(USER_NONE)});
        DistributedFileSystem fs = UTIL.getDFSCluster().getFileSystem();
        Path openDir = fs.makeQualified(new Path("testAccessCase"));
        fs.mkdirs(openDir);
        fs.setPermission(openDir, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
        Path output = fs.makeQualified(new Path(openDir, "output"));
        SecureTestUtil.AccessTestAction exportAction = () -> {
            try {
                String[] args = new String[]{exportTable, output.toString()};
                Map result = Export.run((Configuration)new Configuration(UTIL.getConfiguration()), (String[])args);
                long rowCount = 0L;
                long cellCount = 0L;
                for (Export.Response r : result.values()) {
                    rowCount += r.getRowCount();
                    cellCount += r.getCellCount();
                }
                Assert.assertEquals((long)1L, (long)rowCount);
                Assert.assertEquals((long)2L, (long)cellCount);
                Iterator iterator = null;
                return iterator;
            }
            catch (ServiceException | IOException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                LOG.error((Object)ex);
                throw new Exception(ex);
            }
            finally {
                TestSecureExport.clearOutput(output);
            }
        };
        SecureTestUtil.verifyDenied((SecureTestUtil.AccessTestAction)exportAction, (User[])new User[]{TestSecureExport.getUserByLogin(USER_RO), TestSecureExport.getUserByLogin(USER_XO), TestSecureExport.getUserByLogin(USER_NONE)});
        SecureTestUtil.verifyAllowed((SecureTestUtil.AccessTestAction)exportAction, (User[])new User[]{TestSecureExport.getUserByLogin(USER_ADMIN), TestSecureExport.getUserByLogin(USER_OWNER), TestSecureExport.getUserByLogin(USER_RX)});
        SecureTestUtil.AccessTestAction deleteAction = () -> {
            UTIL.deleteTable(TableName.valueOf((String)exportTable));
            return null;
        };
        SecureTestUtil.verifyAllowed((SecureTestUtil.AccessTestAction)deleteAction, (User[])new User[]{TestSecureExport.getUserByLogin(USER_OWNER)});
        fs.delete(openDir, true);
    }

    @Test
    public void testVisibilityLabels() throws IOException, Throwable {
        String exportTable = this.name.getMethodName() + "_export";
        String importTable = this.name.getMethodName() + "_import";
        TableDescriptor exportHtd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)exportTable)).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILYA)).setOwnerString(USER_OWNER).build();
        SecureTestUtil.createTable((HBaseTestingUtility)UTIL, (TableDescriptor)exportHtd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        SecureTestUtil.AccessTestAction putAction = () -> {
            Put p1 = new Put(ROW1);
            p1.addColumn(FAMILYA, QUAL, NOW, QUAL);
            p1.setCellVisibility(new CellVisibility(SECRET));
            Put p2 = new Put(ROW2);
            p2.addColumn(FAMILYA, QUAL, NOW, QUAL);
            p2.setCellVisibility(new CellVisibility("private & confidential"));
            Put p3 = new Put(ROW3);
            p3.addColumn(FAMILYA, QUAL, NOW, QUAL);
            p3.setCellVisibility(new CellVisibility("!confidential & topsecret"));
            try (Connection conn = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
                 Table t = conn.getTable(TableName.valueOf((String)exportTable));){
                t.put(p1);
                t.put(p2);
                t.put(p3);
            }
            return null;
        };
        SecureTestUtil.verifyAllowed((SecureTestUtil.AccessTestAction)putAction, (User[])new User[]{TestSecureExport.getUserByLogin(USER_OWNER)});
        LinkedList<Pair> labelsAndRowCounts = new LinkedList<Pair>();
        labelsAndRowCounts.add(new Pair(Arrays.asList(SECRET), (Object)1));
        labelsAndRowCounts.add(new Pair(Arrays.asList(PRIVATE, CONFIDENTIAL), (Object)1));
        labelsAndRowCounts.add(new Pair(Arrays.asList(TOPSECRET), (Object)1));
        labelsAndRowCounts.add(new Pair(Arrays.asList(TOPSECRET, CONFIDENTIAL), (Object)0));
        labelsAndRowCounts.add(new Pair(Arrays.asList(TOPSECRET, CONFIDENTIAL, PRIVATE, SECRET), (Object)2));
        for (Pair labelsAndRowCount : labelsAndRowCounts) {
            List labels = (List)labelsAndRowCount.getFirst();
            int rowCount = (Integer)labelsAndRowCount.getSecond();
            Path openDir = new Path("testAccessCase");
            FileSystem fs = openDir.getFileSystem(UTIL.getConfiguration());
            fs.mkdirs(openDir);
            fs.setPermission(openDir, new FsPermission(FsAction.ALL, FsAction.ALL, FsAction.ALL));
            Path output = fs.makeQualified(new Path(openDir, "output"));
            SecureTestUtil.AccessTestAction exportAction = () -> {
                StringBuilder buf = new StringBuilder();
                labels.forEach(v -> buf.append((String)v).append(","));
                buf.deleteCharAt(buf.length() - 1);
                try {
                    String[] args = new String[]{"-D hbase.export.visibility.labels=" + buf.toString(), exportTable, output.toString()};
                    Export.run((Configuration)new Configuration(UTIL.getConfiguration()), (String[])args);
                    return null;
                }
                catch (ServiceException | IOException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new Exception(ex);
                }
            };
            SecureTestUtil.verifyAllowed((SecureTestUtil.AccessTestAction)exportAction, (User[])new User[]{TestSecureExport.getUserByLogin(USER_OWNER)});
            TableDescriptor importHtd = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)importTable)).addColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILYB)).setOwnerString(USER_OWNER).build();
            SecureTestUtil.createTable((HBaseTestingUtility)UTIL, (TableDescriptor)importHtd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
            SecureTestUtil.AccessTestAction importAction = () -> {
                String[] args = new String[]{"-DHBASE_IMPORTER_RENAME_CFS=fma:fma", importTable, output.toString()};
                Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)new Configuration(UTIL.getConfiguration()), (Tool)new Import(), (String[])args));
                return null;
            };
            SecureTestUtil.verifyAllowed((SecureTestUtil.AccessTestAction)importAction, (User[])new User[]{TestSecureExport.getUserByLogin(USER_OWNER)});
            SecureTestUtil.AccessTestAction scanAction = () -> {
                Scan scan = new Scan();
                scan.setAuthorizations(new Authorizations(labels));
                try (Connection conn = ConnectionFactory.createConnection((Configuration)UTIL.getConfiguration());
                     Table table = conn.getTable(importHtd.getTableName());
                     ResultScanner scanner = table.getScanner(scan);){
                    int count = 0;
                    for (Result r : scanner) {
                        ++count;
                    }
                    Assert.assertEquals((long)rowCount, (long)count);
                }
                return null;
            };
            SecureTestUtil.verifyAllowed((SecureTestUtil.AccessTestAction)scanAction, (User[])new User[]{TestSecureExport.getUserByLogin(USER_OWNER)});
            SecureTestUtil.AccessTestAction deleteAction = () -> {
                UTIL.deleteTable(importHtd.getTableName());
                return null;
            };
            SecureTestUtil.verifyAllowed((SecureTestUtil.AccessTestAction)deleteAction, (User[])new User[]{TestSecureExport.getUserByLogin(USER_OWNER)});
            TestSecureExport.clearOutput(output);
        }
        SecureTestUtil.AccessTestAction deleteAction = () -> {
            UTIL.deleteTable(exportHtd.getTableName());
            return null;
        };
        SecureTestUtil.verifyAllowed((SecureTestUtil.AccessTestAction)deleteAction, (User[])new User[]{TestSecureExport.getUserByLogin(USER_OWNER)});
    }

    static {
        KEYTAB_FILE = new File(UTIL.getDataTestDir("keytab").toUri().getPath());
        FAMILYA = Bytes.toBytes((String)"fma");
        FAMILYB = Bytes.toBytes((String)"fma");
        ROW1 = Bytes.toBytes((String)"row1");
        ROW2 = Bytes.toBytes((String)"row2");
        ROW3 = Bytes.toBytes((String)"row3");
        QUAL = Bytes.toBytes((String)"qual");
        NOW = System.currentTimeMillis();
    }
}

