/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.coprocessor.SingletonCoprocessorService;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.DummyRegionServerEndpointProtos;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.RemoteWithExtrasException;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.testclassification.CoprocessorTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={CoprocessorTests.class, MediumTests.class})
public class TestRegionServerCoprocessorEndpoint {
    public static final FileNotFoundException WHAT_TO_THROW = new FileNotFoundException("/file.txt");
    private static HBaseTestingUtility TEST_UTIL = null;
    private static Configuration CONF = null;
    private static final String DUMMY_VALUE = "val";

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        CONF = TEST_UTIL.getConfiguration();
        CONF.setStrings("hbase.coprocessor.regionserver.classes", new String[]{DummyRegionServerEndpoint.class.getName()});
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testEndpoint() throws Exception {
        ServerName serverName = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        ServerRpcController controller = new ServerRpcController();
        CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
        DummyRegionServerEndpointProtos.DummyService service = (DummyRegionServerEndpointProtos.DummyService)ProtobufUtil.newServiceStub(DummyRegionServerEndpointProtos.DummyService.class, (RpcChannel)TEST_UTIL.getAdmin().coprocessorService(serverName));
        service.dummyCall((RpcController)controller, DummyRegionServerEndpointProtos.DummyRequest.getDefaultInstance(), (RpcCallback)rpcCallback);
        Assert.assertEquals((Object)DUMMY_VALUE, (Object)((DummyRegionServerEndpointProtos.DummyResponse)rpcCallback.get()).getValue());
        if (controller.failedOnException()) {
            throw controller.getFailedOn();
        }
    }

    @Test
    public void testEndpointExceptions() throws Exception {
        ServerName serverName = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        ServerRpcController controller = new ServerRpcController();
        CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
        DummyRegionServerEndpointProtos.DummyService service = (DummyRegionServerEndpointProtos.DummyService)ProtobufUtil.newServiceStub(DummyRegionServerEndpointProtos.DummyService.class, (RpcChannel)TEST_UTIL.getAdmin().coprocessorService(serverName));
        service.dummyThrow((RpcController)controller, DummyRegionServerEndpointProtos.DummyRequest.getDefaultInstance(), (RpcCallback)rpcCallback);
        Assert.assertEquals(null, (Object)rpcCallback.get());
        Assert.assertTrue((boolean)controller.failedOnException());
        Assert.assertEquals((Object)WHAT_TO_THROW.getClass().getName().trim(), (Object)((RemoteWithExtrasException)controller.getFailedOn().getCause()).getClassName().trim());
    }

    static class DummyRegionServerEndpoint
    extends DummyRegionServerEndpointProtos.DummyService
    implements Coprocessor,
    SingletonCoprocessorService {
        DummyRegionServerEndpoint() {
        }

        public Service getService() {
            return this;
        }

        public void start(CoprocessorEnvironment env) throws IOException {
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
        }

        public void dummyCall(RpcController controller, DummyRegionServerEndpointProtos.DummyRequest request, RpcCallback<DummyRegionServerEndpointProtos.DummyResponse> callback) {
            callback.run((Object)DummyRegionServerEndpointProtos.DummyResponse.newBuilder().setValue(TestRegionServerCoprocessorEndpoint.DUMMY_VALUE).build());
        }

        public void dummyThrow(RpcController controller, DummyRegionServerEndpointProtos.DummyRequest request, RpcCallback<DummyRegionServerEndpointProtos.DummyResponse> done) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)WHAT_TO_THROW);
        }
    }
}

