/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.TestAsyncAdminBase;
import org.apache.hadoop.hbase.coprocessor.ProtobufCoprocessorService;
import org.apache.hadoop.hbase.coprocessor.SingletonCoprocessorService;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.DummyRegionServerEndpointProtos;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={ClientTests.class, MediumTests.class})
public class TestAsyncCoprocessorEndpoint
extends TestAsyncAdminBase {
    private static final FileNotFoundException WHAT_TO_THROW = new FileNotFoundException("/file.txt");
    private static final String DUMMY_VALUE = "val";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.rpc.timeout", 60000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.operation.timeout", 120000);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        TEST_UTIL.getConfiguration().setStrings("hbase.coprocessor.master.classes", new String[]{ProtobufCoprocessorService.class.getName()});
        TEST_UTIL.getConfiguration().setStrings("hbase.coprocessor.regionserver.classes", new String[]{DummyRegionServerEndpoint.class.getName()});
        TEST_UTIL.startMiniCluster(2);
        ASYNC_CONN = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)TEST_UTIL.getConfiguration()).get();
    }

    @Test
    public void testMasterCoprocessorService() throws Exception {
        TestProtos.EchoRequestProto request = TestProtos.EchoRequestProto.newBuilder().setMessage("hello").build();
        TestProtos.EchoResponseProto response = (TestProtos.EchoResponseProto)this.admin.coprocessorService(TestRpcServiceProtos.TestProtobufRpcProto::newStub, (s, c, done) -> s.echo(c, request, done)).get();
        Assert.assertEquals((Object)"hello", (Object)response.getMessage());
    }

    @Test
    public void testMasterCoprocessorError() throws Exception {
        TestProtos.EmptyRequestProto emptyRequest = TestProtos.EmptyRequestProto.getDefaultInstance();
        try {
            this.admin.coprocessorService(TestRpcServiceProtos.TestProtobufRpcProto::newStub, (s, c, done) -> s.error(c, emptyRequest, done)).get();
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testRegionServerCoprocessorService() throws Exception {
        ServerName serverName = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        DummyRegionServerEndpointProtos.DummyRequest request = DummyRegionServerEndpointProtos.DummyRequest.getDefaultInstance();
        DummyRegionServerEndpointProtos.DummyResponse response = (DummyRegionServerEndpointProtos.DummyResponse)this.admin.coprocessorService(DummyRegionServerEndpointProtos.DummyService::newStub, (s, c, done) -> s.dummyCall(c, request, done), serverName).get();
        Assert.assertEquals((Object)DUMMY_VALUE, (Object)response.getValue());
    }

    @Test
    public void testRegionServerCoprocessorServiceError() throws Exception {
        ServerName serverName = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        DummyRegionServerEndpointProtos.DummyRequest request = DummyRegionServerEndpointProtos.DummyRequest.getDefaultInstance();
        try {
            this.admin.coprocessorService(DummyRegionServerEndpointProtos.DummyService::newStub, (s, c, done) -> s.dummyThrow(c, request, done), serverName).get();
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RetriesExhaustedException));
            Assert.assertTrue((boolean)e.getCause().getMessage().contains(WHAT_TO_THROW.getClass().getName().trim()));
        }
    }

    static class DummyRegionServerEndpoint
    extends DummyRegionServerEndpointProtos.DummyService
    implements Coprocessor,
    SingletonCoprocessorService {
        public Service getService() {
            return this;
        }

        public void start(CoprocessorEnvironment env) throws IOException {
        }

        public void stop(CoprocessorEnvironment env) throws IOException {
        }

        public void dummyCall(RpcController controller, DummyRegionServerEndpointProtos.DummyRequest request, RpcCallback<DummyRegionServerEndpointProtos.DummyResponse> callback) {
            callback.run((Object)DummyRegionServerEndpointProtos.DummyResponse.newBuilder().setValue(TestAsyncCoprocessorEndpoint.DUMMY_VALUE).build());
        }

        public void dummyThrow(RpcController controller, DummyRegionServerEndpointProtos.DummyRequest request, RpcCallback<DummyRegionServerEndpointProtos.DummyResponse> done) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)WHAT_TO_THROW);
        }
    }
}

