/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ColumnAggregationWithErrorsProtos;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class ColumnAggregationEndpointWithErrors
extends ColumnAggregationWithErrorsProtos.ColumnAggregationServiceWithErrors
implements Coprocessor,
CoprocessorService {
    private static final Log LOG = LogFactory.getLog(ColumnAggregationEndpointWithErrors.class);
    private RegionCoprocessorEnvironment env = null;

    public Service getService() {
        return this;
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        if (env instanceof RegionCoprocessorEnvironment) {
            this.env = (RegionCoprocessorEnvironment)env;
            return;
        }
        throw new CoprocessorException("Must be loaded on a table region!");
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sum(RpcController controller, ColumnAggregationWithErrorsProtos.ColumnAggregationWithErrorsSumRequest request, RpcCallback<ColumnAggregationWithErrorsProtos.ColumnAggregationWithErrorsSumResponse> done) {
        byte[] qualifier;
        Scan scan = new Scan();
        byte[] family = request.getFamily().toByteArray();
        byte[] byArray = qualifier = request.hasQualifier() ? request.getQualifier().toByteArray() : null;
        if (request.hasQualifier()) {
            scan.addColumn(family, qualifier);
        } else {
            scan.addFamily(family);
        }
        int sumResult = 0;
        RegionScanner scanner = null;
        try {
            Region region = this.env.getRegion();
            if (Bytes.equals((byte[])region.getRegionInfo().getEndKey(), (byte[])HConstants.EMPTY_END_ROW)) {
                throw new DoNotRetryIOException("An expected exception");
            }
            scanner = region.getScanner(scan);
            ArrayList curVals = new ArrayList();
            boolean hasMore = false;
            do {
                curVals.clear();
                hasMore = scanner.next(curVals);
                for (Cell kv : curVals) {
                    if (!CellUtil.matchingQualifier((Cell)kv, (byte[])qualifier)) continue;
                    sumResult += Bytes.toInt((byte[])kv.getValueArray(), (int)kv.getValueOffset());
                }
            } while (hasMore);
        }
        catch (IOException e) {
            CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
            sumResult = -1;
            LOG.info((Object)"Setting sum result to -1 to indicate error", (Throwable)e);
        }
        finally {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (IOException e) {
                    CoprocessorRpcUtils.setControllerException((RpcController)controller, (IOException)e);
                    sumResult = -1;
                    LOG.info((Object)"Setting sum result to -1 to indicate error", (Throwable)e);
                }
            }
        }
        done.run((Object)ColumnAggregationWithErrorsProtos.ColumnAggregationWithErrorsSumResponse.newBuilder().setSum((long)sumResult).build());
    }
}

